/*
 *  move.c
 *
 *  This file contains the routines necessary to perform the 'move'
 *  operation, which will move an object on the screen, and as a side
 *  effect raise it to the top of the display list.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern MoveObject();
extern RaiseObject();
extern Checkpoint();
extern RedrawActivelist();
extern short SelectObject();
 
 
/* Exports */
extern ActMove();
 
 
/* Local Definitions */
static POINT_DATA prompts[] =
  {
    { "Enter the starting point of the move.", 0, 0, 0, },
    { "Enter the destination of the move.", 0, 0, 0, },
  };

/*
 *  This routine is the main driver for the move command.  It will
 *  call SelectObject() to get the user to pick an object to be moved.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  moved, in the order specified.
 */
 
ActMove( cmd )
	enum MenuOptions cmd;
  {
    register short deltax, deltay;
    short selected, p1, p2, moving;
    ITEM_LIST_PTR *victim;
    register ITEM_LIST_PTR *p;
    
    /* Make ready */
    Checkpoint();
    moving = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (moving)
      {
	moving = SelectObject( &victim, cmd, &p1, &p2,
		"MOVE:  Select an object type.", &selected, 0,
		2, prompts );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    moving = 0;
	    break;
	  }
	
	/* Something was selected. */
	deltax = prompts[1].x - prompts[0].x;
	deltay = prompts[1].y - prompts[0].y;
	if (selected)
	  {
	    /* Everything was selected. */
	    p = activelist->prev;
	    while (p)
	      {
		MoveObject( p, deltax, deltay, 0 );
		p = p->next;
	      }
	    
	    /* Redisplay Everything. */
	    RedrawActivelist( 1 );
	  }
	else if (victim)
	  {
	    /* Move one object */
	    RaiseObject( victim, 0 );
	    MoveObject( victim, deltax, deltay, 1 );
	  }
      }
  }
