/*
 *  raise.c
 *
 *  This file contains the routines necessary to perform the 'lower'
 *  operation, which will lower a specified object to the bottom of the
 *  display list.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern LowerObject();
extern Checkpoint();
extern short SelectObject();
 
 
/* Exports */
extern ActLower();
 
 
/* Local Definitions */

/*
 *  This routine is the main driver for the lower command.  It will
 *  call SelectObject() to get the user to pick an object to be lowered.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  lowered, in the order specified.
 */
 
ActLower( cmd )
	enum MenuOptions cmd;
  {
    short selected, p1, p2, lowering;
    ITEM_LIST_PTR *victim;
    
    /* Make ready */
    Checkpoint();
    lowering = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (lowering)
      {
	lowering = SelectObject( &victim, cmd, &p1, &p2,
		"LOWER:  Select an object type.", &selected, 0,
		0, NULL );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    lowering = 0;
	    break;
	  }
	
	/* Something was selected. */
	if (selected)
	  {
	    /* Everything was selected.  Do nothing. */
	    printf("Lowering everything has no effect.\n\r");
	  }
	else if (victim)
	  {
	    /* Raise one object */
	    LowerObject( victim, 1 );
	  }
      }
  }
