/*
 *  point.c
 *
 *  This file contains the driver routines nexessary to create multi-point
 *  objects (i.e. splines and polygons, open, closed, and filled = 6 objects
 *  This file contains only the code common to all of these objects. See
 *  nouns.c for the item specific code.
 *
 *  This file also contains DefPoint, the routine called when a definite
 *  (small) number of points is needed, each with its own ext prompt.
 *
 *  Gus fernandez (loosely based on David Kaebling's create.c)  4/23/85
 */

/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */

extern SetCurrentCommand();
extern short DoneFlag;		/* Flag to favor Done button for Monkey */
extern OpenMainSymbol();
extern CloseMainSymbol();
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */

/* exports */

extern IndefPoint();
extern DefPoint();

POINT *SplineItems;
/*
 * Indefpoint takes as input the GetInput parameters and will output
 * a spline pointer if all goes well, or NULL if we are not done yet.
 * 
 * cmd is not necessarily the command that the user pressed in the menu.
 * it can be one of:
 *     CDataPoint - Add a point to the object
 *     CDone      - Finished. Return the spline pointer if we have an
 *			adequate number of points
 *     CAbort     - Throw away the current spline.
 *     CUndo      - Undo a single point. May drop into abort if user undo's
 *			too far.
 *     (ourtype)  - start a new object of type ourtype)
 *     other      - error
 */



IndefPoint(ourtype,cmd,x,y,but,closedP,orderP,filledP,typeP)
    enum MenuOptions ourtype, cmd;
    short x, y, but;
    short closedP,orderP,filledP;
    enum ObjTypes typeP;
  {
    register POINT *vert;
    register short nv;
    short i;
    static short frame;
    switch(cmd) {
	case CDataPoint: {
	    if (!CurrentSpline) {
		printf("fatal error! Current spline not allocated\n\r");
		Quit(1);
	    }
	    nv = CurrentSpline->numvert;
	    CurrentSpline = (SPLINE *) realloc( CurrentSpline,
	    		sizeof(SPLINE) + nv * sizeof(POINT) );
	    if (!CurrentSpline)
	      {
		printf("Whoa! Out of memory. Can't add any more points.\n\r");
		return(0);
	      }
	    SplineItems = (POINT *) realloc( SplineItems,
		(nv + 1) * sizeof(POINT) );
	    if (!SplineItems)
	      {
		printf("Out of memory. Can't add any more points.\n\r");
		return(0);
	      }
	    vert = (POINT *) &(CurrentSpline ->head);
	    vert[nv].x = x;
	    vert[nv].y = y;
	    CloseMainSymbol(1);
	    EditSymbol( sdf, frame );
	    SplineItems[nv].x =
		AddItem( sdf, GetINum(), x - 2, x + 2, y - 2, y + 2,
	    	    AllEdges, SDF_OUTLINE, NULL );
	    if (CurrentSpline->numvert != 0)
	      SplineItems[nv].y =
		AddItem( sdf, GetINum(), vert[nv - 1].x, x,
		    vert[nv - 1].y, y, 0,SDF_GENERAL_LINE, NULL);
	    EndSymbol( sdf, frame,mainVgt);
	    CurrentSpline->numvert++;
	    return(0);
	}
	case CUndo: {
	    if (CurrentSpline->numvert != 0) {
		CurrentSpline->numvert -= 1;
		CloseMainSymbol(1);
		EditSymbol( sdf, frame );
		if (CurrentSpline->numvert != 0) {
		    DeleteItem( sdf, SplineItems[CurrentSpline->numvert].y );
		    FreeINum( SplineItems[CurrentSpline->numvert].y );
		}
		DeleteItem( sdf, SplineItems[CurrentSpline->numvert].x );
		FreeINum( SplineItems[CurrentSpline->numvert].x );
		EndSymbol( sdf, frame, mainVgt );
		return(0);
	    }
	}
	case CAbort:
	case CDone: {
	    CurrentSpline->nib = DefaultNib;
	    CurrentSpline->pat = DefaultPat;
            CurrentSpline->border = ((int)DefaultNib>0); 
	    CloseMainSymbol(1);
    	    DeleteSymbol( sdf, frame );
	    OpenMainSymbol();
    	    DeleteItem( sdf, frame + 1 );
    	    FreeINum( frame + 1 );
    	    FreeINum( frame );
	    for (i=0;i<CurrentSpline->numvert;i++) {
		if (i >0) {
		    FreeINum( SplineItems[i].y );
		}
		FreeINum( SplineItems[i].x );
	    }
	    free( SplineItems);
            if (CurrentSpline->numvert != 0 && cmd != CAbort) {
		NewObject( CurrentSpline, typeP,
			 0, 0, 0, 0, 0, 0, 0, NULL, 1, 0, 0 );
		DeleteMessage(0);
	    }
	    else {
		free( CurrentSpline );
		mprintf(1,"Aborted!\n\r");
		SetCurrentObject(NULL,1);
		RevertToCKP();
	    }
    	    CurrentSpline = NULL;
	    SplineItems = NULL;
	    SetCurrentCommand(CNull);
	    HilightCommand(CDone,0);
	    DoneFlag = 0;	/* Flag to favor done for monkey */
    	    return(0);
	}
	default: {
	    if (ourtype==cmd) {
		SetCurrentObject(NULL,1);
    		if ((CurrentSpline = (SPLINE *) malloc( sizeof(SPLINE) ))
			 == NULL) {
		    printf("Whoa!  Out of memory.");
		    printf(" Can't add ANYTHING right now.\n\r");
		    return(0);
      		}
    		if ((SplineItems = (POINT *) malloc( sizeof(POINT) ))
			 == NULL) {
		    printf("Out of memory.");
		    printf(" Can't add ANYTHING right now.\n\r");
		    return(0);
      		}
		Checkpoint();
		SetCurrentCommand(cmd);
    		CurrentSpline->order = orderP;
    		CurrentSpline->numvert = 0;
    		CurrentSpline->closed = closedP;
	        CurrentSpline->filled = filledP;
	        CurrentSpline->opaque = 1;
    
    		/* Prepare to display the frame */
		CloseMainSymbol(1);
    		frame = DefineSymbol( sdf, GetSeqINum(2), "Temporary Spline Frame" );
    		EndSymbol( sdf, frame, 0 );
		OpenMainSymbol();
    		AddCall( sdf, frame+1, 0, 0, frame );
    		mprintf(0,"Place the control points.\n\rClick 'Done' when finished.\n\r");
		HilightCommand(CDone,2);
	        DoneFlag = 1;	/* Flag to favor done for monkey */
		return(0);
	    }
	    else {
		PrintCommand(ourtype,0);PrintCommand(cmd,0);
		printf("error in draw program: bad call to indefpoint\n\r");
		Quit();
	    }
	}
    }
    /*NOTREACHED*/
  }



/*
 * This routine is used like IndefPoint, but when a definite (small) number
 * of points are needed. Each point has special significance and has a label
 * of its own as declared in pntdat. Returns 1 if done. (pntdat has data)
 * 0 otherwise. numpnt is the number of points required. eqcheck is set
 * to non-zero to ensure that point (eqcheck) (usually 1) is different from
 * point 0.
 */
 
DefPoint(ourtype,cmd,x,y,but,numpnt,pntdat,eqcheck)
	enum MenuOptions ourtype, cmd;
	short x,y,but;
	short numpnt;
	POINT_DATA *pntdat;
  {

  switch(cmd) {
    case CDataPoint: {
	if (PointState < 0) {
	    printf("Fatal error. Bad call to DefPoint(DataPoint)\n\r");
	    Quit();
	}
	if (Debug&DebugPoint)
	  printf("Found point %d of %d at (%d, %d)\n\r",
		PointState, numpnt, x, y);
	if (eqcheck>0 && PointState==eqcheck && 
                         pntdat[0].x==x && pntdat[0].y==y) {
	    mprintf(2,"don't use the same point as the first!\n\r%s",
		pntdat[PointState].prompt);
	    return(0);
	}
	pntdat[PointState].x = x;
	pntdat[PointState].y = y;
	OpenMainSymbol();
	pntdat[PointState].flag = AddItem( sdf, GetINum(), 
		x - 2, x + 2, y - 2, y + 2,
		AllEdges, SDF_OUTLINE, NULL );
	PointState++;
	if (PointState<numpnt) {
    	    mprintf(0,"%s\n\r", pntdat[PointState].prompt );
	    return(0);
	}
	else {
	    SetCurrentCommand(CNull);
	    DeleteMessage(0);
	    OpenMainSymbol();
  	    while (--PointState >= 0) {
    		DeleteItem( sdf, pntdat[PointState].flag );
    		FreeINum( pntdat[PointState].flag );
  	    }
	    PointState = -1;
  	    return(1);
        }
    }
    case CUndo:
	if (PointState > 0) {
	    PointState--;
	    OpenMainSymbol();
	    DeleteItem( sdf, pntdat[PointState].flag );
	    FreeINum( pntdat[PointState].flag );
    	    mprintf(0,"Backing up:\n\r%s\n\r", pntdat[PointState].prompt );
	    return(0);
	}
    case CAbort:
    case CDone: {
	    /* If we were selecting points, discard them */
	    OpenMainSymbol();
	    while (--PointState >= 0) {
	        DeleteItem( sdf, pntdat[PointState].flag );
	        FreeINum( pntdat[PointState].flag );
	    }
	    mprintf(1,"Aborted!\n\r");
	    SetCurrentCommand(CNull);
	    RevertToCKP();
	    return(0);
       }
    default: {
	    if (ourtype==cmd) {
		PointState=0;
    	        mprintf(0,"%s\n\r", pntdat[PointState].prompt );
		SetCurrentCommand(cmd);
		Checkpoint();
		return(0);
	    }
	    else {
		PrintCommand(ourtype,0);PrintCommand(cmd,0);
		printf("Error in draw program: bad call to defpoint.\n\r");
		Quit();
	    }
	}
     }
     /*NOTREACHED*/
  }
