/*
 *  icons.c
 *
 *  This file contains the definitions for the various icons used in the
 *  draw commands menu. Noun icons are 32bits square. Verb icons are 32 bits
 *  high and 64 bits wide. The actual hex definitions are in the icons/nouns
 *  and icons/verbs directories, and were created using the "bits" utility.
 *
 *  Gus Fernandez 4/19/85
 */

#include "icons.h"
#define ICONDAT unsigned char

/*
 * local definitions
 */
 
/*
	NOUNS
*/
 
ICONDAT IcNclosedcircle[] = {
#include "icons/nouns/closedcircle.hex"
    };

ICONDAT IcNclosedcurve[] = {
#include "icons/nouns/closedcurve.hex"
    };

ICONDAT IcNclosedelipse[] = {
#include "icons/nouns/closedelipse.hex"
    };

ICONDAT IcNclosedpolygon[] = {
#include "icons/nouns/closedpolygon.hex"
    };

ICONDAT IcNclosedrectangle[] = {
#include "icons/nouns/closedrectangle.hex"
    };
 
ICONDAT IcNfilledcircle[] = {
#include "icons/nouns/filledcircle.hex"
    };

ICONDAT IcNfilledcurve[] = {
#include "icons/nouns/filledcurve.hex"
    };

ICONDAT IcNfilledelipse[] = {
#include "icons/nouns/filledelipse.hex"
    };

ICONDAT IcNfilledpolygon[] = {
#include "icons/nouns/filledpolygon.hex"
    };

ICONDAT IcNfilledrectangle[] = {
#include "icons/nouns/filledrectangle.hex"
    };

ICONDAT IcNnarrowclosedarrow[] = {
#include "icons/nouns/narrowclosedarrow.hex"
    };

ICONDAT IcNnarrowopenarrow[] = {
#include "icons/nouns/narrowopenarrow.hex"
    };

ICONDAT IcNopencurve[] = {
#include "icons/nouns/opencurve.hex"
    };

ICONDAT IcNopenpolygon[] = {
#include "icons/nouns/openpolygon.hex"
    };

ICONDAT IcNpresseditsymbol[] = {
#include "icons/nouns/presseditsymbol.hex"
    };

ICONDAT IcNtext[] = {
#include "icons/nouns/text.hex"
    };

ICONDAT IcNwideclosedarrow[] = {
#include "icons/nouns/wideclosedarrow.hex"
    };

ICONDAT IcNwideopenarrow[] = {
#include "icons/nouns/wideopenarrow.hex"
    };

/*
	VERBS
*/

ICONDAT IcValter[] = {
#include "icons/verbs/alter.hex"
    };

ICONDAT IcVcopy[] = {
#include "icons/verbs/copy.hex"
    };

ICONDAT IcVerase[] = {
#include "icons/verbs/erase.hex"
    };

ICONDAT IcVgroup[] = {
#include "icons/verbs/group.hex"
    };

ICONDAT IcVlower[] = {
#include "icons/verbs/lower.hex"
    };

ICONDAT IcVmove[] = {
#include "icons/verbs/move.hex"
    };

ICONDAT IcVopaque[] = {
#include "icons/verbs/opaque.hex"
    };

ICONDAT IcVraise[] = {
#include "icons/verbs/raise.hex"
    };

ICONDAT IcVrotate[] = {
#include "icons/verbs/rotate.hex"
    };

ICONDAT IcVscale[] = {
#include "icons/verbs/scale.hex"
    };

ICONDAT IcVstretch[] = {
#include "icons/verbs/stretch.hex"
    }; 

ICON_DESCRIPTOR IconList[] =
  {
    IcNopenpolygon,0,0,0,0,0,
    IcNopencurve,0,0,0,0,0,
    IcNwideopenarrow,0,0,0,0,0,
    IcNwideclosedarrow,0,0,0,0,0,
    IcNnarrowopenarrow,0,0,0,0,0,
    IcNnarrowclosedarrow,0,0,0,0,0,

    IcNclosedpolygon,0,0,0,0,0,
    IcNclosedcurve,0,0,0,0,0,
    IcNclosedcircle,0,0,0,0,0,
    IcNclosedelipse,0,0,0,0,0,
    IcNclosedrectangle,0,0,0,0,0,
    IcNpresseditsymbol,0,0,0,0,0,

    IcNfilledpolygon,0,0,0,0,0,
    IcNfilledcurve,0,0,0,0,0,
    IcNfilledcircle,0,0,0,0,0,
    IcNfilledelipse,0,0,0,0,0,
    IcNfilledrectangle,0,0,0,0,0,
    IcNtext,0,0,0,0,0,
    
    IcVmove,0,0,0,0,0,
    IcVcopy,0,0,0,0,0,
    IcVerase,0,0,0,0,0,
    IcValter,0,0,0,0,0,
    IcVrotate,0,0,0,0,0,
    IcVscale,0,0,0,0,0,
    IcVstretch,0,0,0,0,0,
    IcVgroup,0,0,0,0,0,
    IcVraise,0,0,0,0,0,
    IcVlower,0,0,0,0,0,
    IcVopaque,0,0,0,0,0,
  };
