# define MAXCLICK	   10	/* Max. number of UnGetInput's allowed. */
# define NUMBACKUP	   10	/* Number of undo backup lists to maintain */
# define MAXLEN		  120	/* Maximum string length */
# define MAXGROUP	   13	/* Max. number of groups allowed */
# define MAXDIST	10000	/* Max. distance from an item */
# define MAXNIB		   16	/* Number of nibs */
# define MAXPAT		   28   /* Number of patterns */
# define FILEHEADER	"(* V Draw program data file version 2.0*)\n"
# define JOURNALHEADER  "(* V Draw program journal file version 2.0*)\n"
# define OLDFILEHEADER  "(* SUN Draw program data file version 2.0*)\n"
# define JOURNALNAME    "Draw.journal"

/*text centering*/

# define PositionRight	    0	/* Position Text by lower right corner. */
# define PositionCenter	    1	/* Position Text by center of bottom edge. */
# define PositionLeft	    2	/* Position Text by lower left corner. */

/*psm file destinations*/

#define PRINTER_DEST	    0	/* For printing directly */
#define DOCUMENT_DEST	    1	/* For inclusion inside a text document */
#define SAVE_DEST	    2   /* For readiing back directly into Draw */

/* The following cannot change else draw files will be incompatible. */

enum ObjTypes
  {
    TextObj,			/* Text of an arbitrary font. */
    OpenSplineObj,		/* Open spline (curve). */
    ClosedSplineObj,		/* Closed spline. */
    OpenPolygonObj,		/* Open polygon (spline of order 2) */
    ClosedPolygonObj,		/* Closed polygon. */
    GroupObj,			/* Collection of other objects. */
    TemplateObj,		/* Standard shape. */
  };
   
/* These are the states of the global Journal flag */
enum JournalMode
  {
    JournalOff,			/* No journaling is taking place */
    JournalRecord,		/* Record mode. (events being writen to file)*/
    JournalPlay,		/* Playback mode. (events being read back in)*/
  };

enum TemplateTypes
  {
    NarArrowO,			/* Narrow Open Arrowhead. */
    NarArrowC,			/* Narrow Closed Arrowhead. */
    WideArrowO,			/* Wide Open Arrowhead. */
    WideArrowC,			/* Wide Closed Arrowhead. */
    Oval,			/* An oval. */
    Circle,			/* A circle */
    Rectangle,			/* A rectangle */
    NullTemplate,		/* Nothing. */
  };

typedef struct
  {
    char	*fontname;	/* Font name (eg, TimesRoman12B) */
    short	refnumber;	/* Vgts font identification number */
    short	loaded;		/* Font has been defined? */
    short	psmfont;	/* PSM font number (0 if none) */
    short	psmsize;	/* PSM point size */
  } FONTDATA;


/*
 * All objects are kept in a central objects list, called the
 * itemlist.  Objects are stored in the format below.  The data
 * field points to a set of ITEM_LIST_PTRs for groups, which defines
 * the members of the group and gives their relative displacements.
 * For text data is the actual character string.
 */
typedef struct ItemDescriptor
  {
    char			*data;		/* Generic data pointer */
    struct ItemDescriptor	*prev, *next;	/* Links within itemlist */
    enum ObjTypes		type;		/* Object type */
    short			subtype;	/* Template type, font num */
    short			typedata;	/* Centering style, copy # */
    short			number;		/* Vgts item number */
    short			symbol;		/* Vgts symbol number. */
    short			refs;		/* Reference count. */
    short			xmin, xmax, ymin, ymax;	/* Bounding box */
    short			base;		/* Text baseline. */
    char			*name;		/* Group Name */
    short			filnum;		/* Misc. for file i/o */
  }  ITEM_DESCRIPTOR;

/*
 * All of the objects currently being displayed are pointed to by
 * an entry in the activelist.  Each entry has the format below.  The
 * undo logs consist of old copies of the activelist.
 */
typedef struct ItemListPtrBlock
  {
    ITEM_DESCRIPTOR		*itemdesc;	/* itemlist entry */
    short			dx, dy;		/* relative offset */
    short			flag;		/* miscellaneous */
    short			call;		/* number of symbol call */
	/* next -> item just ABOVE current item.
		   (next was raised, or entered more recently) */
	/* prev -> item just BELOW current item.
		   (prev was lowered, or entered earlier) */
	/* paren -> INTEM_LIST_PTR of the group item that this item belongs
			to, or NULL if it is a top-level item. */
    struct ItemListPtrBlock	*parent,*prev, *next;
  }  ITEM_LIST_PTR;

/*
 * The DefPoint() routine can prompt the user for a variable number
 * of data points.  The storage for these points, along with the specific
 * prompt for each point, is kept in arrays with each entry of the type
 * described below.
 */
typedef struct
  {
    char 	*prompt;
    short	x, y;
    short	flag;
  }  POINT_DATA;

/*
 * The commands menu data structures are of the type below.
 */

typedef struct
  {
    char	*string;
    short	itemno;
    short	state;
  }  MenuData;
    

typedef int (*PFI)();

/*
 * dispatchtype deals with how a particular command affects the current machine
 * state as specified in the CurrentCommand variable
 */
enum dispatchtype {
    none,		/* command neither sets nor breaks a state */
    brk,		/* command breaks a state but does not set its own */
    set,		/* command sets its own state */
    dbl,		/* double click command */
};

typedef struct dispatch {
    PFI routine;	/* the function pointer of the routine to call*/
    enum dispatchtype type; /* how it affects CurrentCommand */
} DISPATCH;

extern DISPATCH Dispatch[];
extern int NumCommands;		/* Number of entries in the Commands menu */
extern MenuData Commands[];	/* Commands menu data. */
extern ITEM_LIST_PTR *Groups[MAXGROUP];	/* Group menu data. */
extern short Patterns[MAXPAT]; 		/* Itemnums for fill patterns*/
extern short Nibs[MAXNIB];		/* 4 sizes x 4 shapes */ 
extern short Debug;			/* Print Debugging information? */
extern short sdf;			/* Vgts structured display file no. */
extern short menuSymbol;		/* Vgts menu symbol number */
extern short mainSymbol;		/* Vgts drawing area symbol number */
extern short menuVgt;			/* Vgts menu Virtual Graphics Term. */
extern short mainVgt;			/* Vgts drawing area VGT */
extern enum Nib DefaultNib;		/* Default Nib for line drawing. */
extern enum Pattern DefaultPat;		/* Default fill pattern */
extern short DefaultOpaque;		/* Use solid fill patterns? */
extern short DefaultFilling;		/* Fill closed objects? */
extern short DefaultCentering;		/* Text Positioning method */
extern short DefaultFont;		/* Default Font for text. */
extern enum MenuOptions CurrentCommand;	/* Current command. */
extern enum MenuOptions PrevCommand;	/* previous command for again */
extern SPLINE *CurrentSpline;		/* Current spline */
extern short PointState;		/* current point in DefPoint */
extern ITEM_LIST_PTR *CurrentObject;	/* Current object in activelist. */
extern short modified;			/* Unwritten changes exist? */
extern ITEM_DESCRIPTOR *itemlist;	/* Central Object Descriptor list */
extern ITEM_LIST_PTR *activelist;	/* Current (active) object display */
extern short NumBackup, CurrentBackup;	/* Backup information */
extern ITEM_LIST_PTR *backuplists[];	/* Backup information */
extern FONTDATA FontData[];		/* Loaded font table */
extern short Monkey,MonkeySteps;	/* Monkey flag and steps remaining */
extern enum JournalMode Journal,OldJournal; /* Curr and prev journaling mode */
extern FILE *JournalFIn,*JournalFOut;	/* Journaling I/O files */
extern int JournalSteps,OldJournalSteps; /* Number of steps in journal file */
extern BOOLEAN SaveJournal;		/* Delete journal on Quit unless save*/
extern BOOLEAN PrintersSearched; /* TRUE if printer names have been searched */

enum MenuOptions
  {
    CNull,		/* Bad command.  User missed everything. */
#define C_NOUNS ((int) COpenPolygon)
    COpenPolygon,	/* Selections from the Nouns menu */
    COpenCurve,         /* sync with icons.c, icons.h */
    CWideOpenArrow,
    CWideClosedArrow,
    CNarrowOpenArrow,
    CNarrowClosedArrow,
    CClosedPolygon,
    CClosedCurve,
    CClosedCircle,
    CClosedElipse,
    CClosedRectangle,
    CPressEditSymbol,
    CFilledPolygon,
    CFilledCurve,
    CFilledCircle,
    CFilledElipse,
    CFilledRectangle,
    CText,
#define C_VERBS ((int) CMove)
    CMove,		/* Selections from the Verbs Menu */
    CCopy,		/* sync with icons.c, icons.h */
    CErase,
    CAlter,
    CRotate,
    CScale,
    CStretch,
    CGroup,
    CRaise,
    CLower,
    COpaque,
#define C_COMMANDS ((int) CDone)
    CDone,		/* Selections from the Commands menu */
    CUndo,		/* sync with init.c */
    CAbort,
    CLoad,
    CSave,
    CPrint,
    CAll,
    CClear,
    CQuit,
    CFont1,
    CFont2,
    CHelp,
    CNib,		/* Any  nib selection */
    CPattern,		/* Any pattern selection */
    CDataPoint,		/* Commands entered through the mouse keys. */
    CCenter,		/* Default centering command */
    CAgain,		/* Done, followed by redu current state. */
    CToggleSelect,	/* Add/delete to selection for group inclusion. */
  };

/* Debug flags */

#define DebugBackend 	1
#define DebugFind	2
#define DebugInput	4
#define DebugEvents	8
#define Debug_INum	16
#define DebugIO		32
#define DebugPoint	64
#define DebugMessages	128

#define DEBUG_ITEMS	8
