/*
 *  draw.c
 *
 *  This file contains the main driver routine for the draw program.
 *
 *  David Kaelbling, April 1983
 *  Gus Fernandez 4/23/85 - An almost complete rewrite!
 */
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# include "Venviron.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
    
/* Imports */
    extern CommandNull();
    extern CommandOpenPolygon();
    extern CommandOpenCurve();
    extern CommandWideOpenArrow();
    extern CommandWideClosedArrow();
    extern CommandNarrowOpenArrow();
    extern CommandNarrowClosedArrow();
    extern CommandClosedPolygon();
    extern CommandClosedCurve();
    extern CommandClosedCircle();
    extern CommandClosedElipse();
    extern CommandClosedRectangle();
    extern CommandPressEditSymbol();
    extern CommandFilledPolygon();
    extern CommandFilledCurve();
    extern CommandFilledCircle();
    extern CommandFilledElipse();
    extern CommandFilledRectangle();
    extern CommandText();
    extern CommandMove();
    extern CommandCopy();
    extern CommandErase();
    extern CommandAlter();
    extern CommandRotate();
    extern CommandScale();
    extern CommandStretch();
    extern CommandGroup();
    extern CommandRaise();
    extern CommandLower();
    extern CommandOpaque();
    extern CommandDone();
    extern CommandUndo();
    extern CommandAbort();
    extern CommandLoad();
    extern CommandSave();
    extern CommandPrint();
    extern CommandAll();
    extern CommandClear();
    extern CommandQuit();
    extern CommandFont1();
    extern CommandFont2();
    extern CommandHelp();
    extern CommandNib();
    extern CommandPattern();
    extern CommandDataPoint();
    extern CommandCenter();
    extern CommandAgain();
    extern CommandToggleSelect();

    extern CloseMainSymbol();


extern Initialize();


/*
 *  This is the master function dispatch array. Make sure is syncs with
 *  Enum MenuOptions in draw.h
 */

DISPATCH dispatch[] = {
    CommandNull,		none,		
    CommandOpenPolygon,		set,
    CommandOpenCurve,         	set,
    CommandWideOpenArrow,	set,
    CommandWideClosedArrow,	set,
    CommandNarrowOpenArrow,	set,
    CommandNarrowClosedArrow,	set,
    CommandClosedPolygon,	set,
    CommandClosedCurve,		set,
    CommandClosedCircle,	set,
    CommandClosedElipse,	set,
    CommandClosedRectangle,	set,
    CommandPressEditSymbol,	set,
    CommandFilledPolygon,	set,
    CommandFilledCurve,		set,
    CommandFilledCircle,	set,
    CommandFilledElipse,	set,
    CommandFilledRectangle,	set,
    CommandText,		set,
    CommandMove,		set,
    CommandCopy,		set,
    CommandErase,		set,
    CommandAlter,		set,
    CommandRotate,		set,
    CommandScale,		set,
    CommandStretch,		set,
    CommandGroup,		brk,
    CommandRaise,		brk,
    CommandLower,		brk,
    CommandOpaque,		brk,
    CommandDone,		none,
    CommandUndo,		none,
    CommandAbort,		none,
    CommandLoad,		brk,
    CommandSave,		brk,
    CommandPrint,		brk,
    CommandAll,			brk,
    CommandClear,		dbl,
    CommandQuit,		dbl,
    CommandFont1,		none,
    CommandFont2,		none,
    CommandHelp,		none,
    CommandNib,			none,
    CommandPattern,		none,
    CommandDataPoint,		none,
    CommandCenter,		none,
    CommandAgain,		none,
    CommandToggleSelect,	brk,
  };

/*
 *  The 'real' main procedure, which does all of the work.
 */
 
realmain()
  {
    short running = 1;		/* Is the program still running? */
    enum MenuOptions cmd;
    short x, y, but;
    short dx,dy;
    
    /* Initialize everything */
    Initialize();
    
    /* Main Loop */
    while (running)
      {
	if (CurrentCommand != CNull)
	    PrevCommand = CurrentCommand;
	GetInput( &cmd, &x, &y, &but );
        if (Debug&DebugEvents)
          {
	    PrintCommand( cmd,x,y,but);
	    printf("\n\r");
          }
	Hilight(cmd,x,TRUE);
	if (CurrentCommand != cmd || dispatch[(int)cmd].type != dbl)
	    if (CurrentCommand != CNull && dispatch[(int)cmd].type != none)
	    	if (but==7)
		    (*dispatch[(int)CurrentCommand].routine)(CAbort,x,y,but);
	    	else
		    (*dispatch[(int)CurrentCommand].routine)(CDone,x,y,but);
	(*dispatch[(int)cmd].routine)(cmd,x,y,but);
	if (cmd != CurrentCommand)
	    Hilight(cmd,x,FALSE);
	CloseMainSymbol(1);
      }

    Quit(0);
  }

/*
 * This is the null command. It does a lot of nothing.
 */
CommandNull(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
}

/*
 * This command is called whenever the user clicks in the drawing area
 * If a command is active, then send the DataPoint message to it, else select
 * an object
 */
CommandDataPoint(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull)
	(*dispatch[(int)CurrentCommand].routine)(CDataPoint,x,y,but);
    else
	SelectObject(x,y,but);
}

/*
 * This command is called whenever the user clicks in the drawing area
 * with the left and right mouse buttons. It is used to add an object to
 * the current selection.
 */
CommandToggleSelect(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull)
	printf("Internal error - ToggleSelect called at bad time.\n");
    else
	SelectObject(x,y,but);
}

/*
 *  This is the Undo command. If a command is active, send it the undo message,
 *  else pop the checkpoint queue.
 */
CommandUndo(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull)
	(*dispatch[(int)CurrentCommand].routine)(CUndo,x,y,but);
    else
	RevertToCKP();
}

/*
 *  This is the Abort command. If a command is active, send it the 
 *  abort message, else, display an error message.
 */
CommandAbort(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull)
	(*dispatch[(int)CurrentCommand].routine)(CAbort,x,y,but);
    else
	mprintf(2,"There is nothing to abort.\n\rTry Undo or Quit instead.\n\r");
}

/*
 *  This is the Done command. If a command is active, send it the 
 *  Done message, else, display an error message.
 */
CommandDone(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull)
	(*dispatch[(int)CurrentCommand].routine)(CDone,x,y,but);
    else
	mprintf(2,"You are not doing anything.\n\rTry Save or Quit if you are done editing\n\r");
}

/*
 *  This is the Again command. If a command is active, send it the 
 *  Done message, and then send it its own, else, display an error message.
 */
CommandAgain(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    if (CurrentCommand!=CNull) {
	PrevCommand=CurrentCommand;
	(*dispatch[(int)CurrentCommand].routine)(CDone,x,y,but);
    }
    (*dispatch[(int)PrevCommand].routine)(PrevCommand,x,y,but);
/*    if (CurrentCommand==PrevCommand) 
	(*dispatch[(int)CurrentCommand].routine)(CDataPoint,x,y,but);
*/
}

/*
 *  Tidy up the window manager and punt.
 *  NOTE: This routine may get called twice in the V version of Draw -
 *  once by each process, so make sure that all flags are reset as resources
 *  are de-allocated.
 */
 
Quit(exitCode)
    int exitCode;
  {
    /* If the main drawing VGT was created, destroy it. */
    if (mainVgt)
        DeleteVGT( mainVgt, 1 );
    mainVgt = 0;
    
    /* If the menu VGT was created, destroy it too. */
    if (menuVgt)
        DeleteVGT( menuVgt, 1 );
    menuVgt = 0;
    
    /* If an SDF was allocated, release it. */
    if (sdf)
        DeleteSDF( sdf );
    sdf = 0;
    
    /* Restore the TTY cooking */
    ResetTTY();

    /* 
     * Close the journal files. (A normal Quit may have already deleted the
     * output file. If not, close it and inform the user that the journal
     * is still there.
     */

    if (JournalFIn != NULL)
        fclose(JournalFIn);
    JournalFIn = NULL;
    if (JournalFOut != NULL) {
	fclose(JournalFOut);
	JournalFOut = NULL;
	printf("A journal file, %s, has been saved in the current directory.\n",
		JOURNALNAME);
	printf("Please rename it if you intend to keep it.\n");
    }

    /* Stop processing */
    Exit(exitCode);
  }

Exit(exitCode)
    int exitCode;
  {
# ifdef UNIX
    exit(exitCode);
# else
    /*
     *  If invoked from the team root, then call "exit()", otherwise send a
     *  message to the creator.
     */
    if ( GetPid(0, LOCAL_PID) == GetTeamRoot(0) )
        exit(exitCode);
    else
      {
	Message msg;
	
	msg[0] = exitCode;
	Send(msg, Creator(0));
      }
# endif
  }


/*
 *  This dummy main procedure allocates a larger stack and invokes
 *  'realmain'.
 */
main()
  {
# ifdef UNIX
    realmain();
# else
    Process_id pid;
    Message msg;
    
    pid = Create( 5, realmain, 0x4000 );
    Ready( pid, 0 );
    
    ReceiveSpecific( msg, pid );
    Quit(msg[0]);
# endif
  }
