@device(VPostscript)
@make(report)

DRAW has the capability of creating a press file suitable for sending to
the Dover printer, or for inclusion inside a text document. (for example,
using the Scribe @@PressPicture command) Choose the ``generate a press file''
option from the @i(Misc) menu. You will be prompted for a file name.
Pressing @I(RETURN) without any file name will send the file directly to
the Dover. Because of the limitations of the Dover, filled splines and
polygons cannot be printed. These objects will appear unfilled and a warning
message will be displayed on the terminal. Some objects are also just too
complicated for the Dover to print. In this case, either garbage output
will be produced, or the ``press file too complicated'' message will be
printed on the header page with no other output. 

@begin(description)

To insert a picture in a Scribe document, first place a PressEdit caption
symbol (a text item showing ``<==<<'') in the bottom center of your picture.
Then, issue the ``generate a press file'' command to save the file to disk.
Then insert the line

@begin(programexample)
    @@libraryfile[picture]
@end(programexample)

near the beginning of your 
scribe input (.mss) file, and lines like the ones shown below
at the point where you want the picture to appear.
@begin (programexample)

    ...like that shown in figure @@ref(press-example).

    @@Begin (Figure)
    @@Pic(file="bridge.fig", height="3.0inches")
    @@Caption (An example figure)
    @@tag (press-example)
    @@End (Figure)
    @Picture(size= 1.555in, Postscript="hello.psf")
@end(programexample)

This will produce output like that shown in figure @ref(press-example-figure).
    @Begin (Figure)
    @Picture(size= 3.2in, Postscript="mogul.psf")
    @Caption (An example figure)
    @tag (press-example-figure)
    @End (Figure)

@b[Undo]@\
There are actually two forms of the @t[Undo] command.  If you select it
while at the top level (when there are no other commands in progress), the
effect will be to revert to the previous checkpoint, in effect undoing the
last command. 

@End(description)
