/*
 *  draw.c
 *
 *  This file contains the main driver routine for the draw complex.
 *
 *  David Kaelbling, April 1983
 */
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# include "Venviron.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
    
/* Imports */
extern Highlight();
extern HighlightStatic();
extern GetInput();
extern UnGetInput();
extern Checkpoint();
extern RevertToCKP();
    
extern DefNib();
extern DefPattern();
extern DefFilling();
extern DefText();
extern PermMisc();
extern PermHelp();
extern PermExit();
extern ActRotate();
extern ActScale();
extern ActMove();
extern ActCopy();
extern ActDraw();
extern ActAlter();
extern ActErase();
extern ActLower();
extern ActRaise();

/*
 *  The 'real' main procedure, which does all of the work.
 */
 
realmain()
  {
    short running = 1;		/* Is the program still running? */
    enum MenuOptions cmd;
    short x, y, but;
    
    /* Initialize everything */
    Initialize();
    
    /* Main Loop */
    while (running)
      {
	GetInput( &cmd, &x, &y, &but );
	CurrentCmd = cmd;
	switch (cmd)
	  {
	    case CNull:
	        break;
	    
	    case CRotate:
		Highlight( &(Commands[1]) );
		ActRotate( CNull );
		Highlight( &(Commands[1]) );
		break;
		
	    case CScale:
		Highlight( &(Commands[2]) );
		ActScale( CNull );
		Highlight( &(Commands[2]) );
		break;
		
	    case CMove:
		Highlight( &(Commands[3]) );
		ActMove( CNull );
		Highlight( &(Commands[3]) );
		break;
		
	    case CCopy:
		Highlight( &(Commands[4]) );
		ActCopy( CNull );
		Highlight( &(Commands[4]) );
		break;
		
	    case CDraw:
		Highlight( &(Commands[5]) );
		ActDraw( CNull );
		Highlight( &(Commands[5]) );
		break;
		
	    case CAlter:
		Highlight( &(Commands[6]) );
		ActAlter( CNull );
		Highlight( &(Commands[6]) );
		break;
		
	    case CErase:
		Highlight( &(Commands[7]) );
		ActErase( CNull );
		Highlight( &(Commands[7]) );
		break;
		
	    case CLower:
		Highlight( &(Commands[8]) );
		ActLower( CNull );
		Highlight( &(Commands[8]) );
		break;
		
	    case CRaise:
		Highlight( &(Commands[9]) );
		ActRaise( CNull );
		Highlight( &(Commands[9]) );
		break;
		
	    
	    case CAllObj:
		printf("Pick a 'command' first, then an object type.\n\r");
		break;
	    
	    case CText:		/* Default to the Draw command. */
	    case COpenCurve:
	    case CClosedCurve:
	    case CCurrentObj:
	    case COpenPolygon:
	    case CClosedPolygon:
	    case CGroup:
	    case CTemplate:
		Highlight( &(Commands[5]) );
		ActDraw( cmd );
		Highlight( &(Commands[5]) );
		break;
	    
	    case CAlmostDone:
	    case CDone:
		HighlightStatic( &(StaticMenu[0]) );
		printf("Done only applies to a command in progress,");
		printf(" and there isn't one.\n\r");
		HighlightStatic( &(StaticMenu[0]) );
		break;
		
	    case CAbort:
		HighlightStatic( &(StaticMenu[1]) );
		printf("Abort only applies to a command in progress,");
		printf(" and there isn't one.\n\r");
		HighlightStatic( &(StaticMenu[1]) );
		break;
		
	    case CUndo:
		HighlightStatic( &(StaticMenu[2]) );
		RevertToCKP();
		printf("Reverting to checkpoint %d.\n\r", CurrentBackup);
		HighlightStatic( &(StaticMenu[2]) );
		break;
		
	    case CMisc:
		HighlightStatic( &(StaticMenu[3]) );
		PermMisc();
		HighlightStatic( &(StaticMenu[3]) );
		break;
		
	    case CHelp:
		HighlightStatic( &(StaticMenu[4]) );
		PermHelp();
		HighlightStatic( &(StaticMenu[4]) );
		break;
		
	    case CExit:
		HighlightStatic( &(StaticMenu[5]) );
		PermExit();
		HighlightStatic( &(StaticMenu[5]) );
		break;
		
	    case CNib:
		DefNib();
		break;
		
	    case CPattern:
		DefPattern();
		break;
		
	    case CFilling:
		DefFilling();
		break;
		
	    case CTextDefault:
		DefText();
		break;
	
	    case CDataPoint:
		printf("Oops! Only commands are legal now.\n\r");
		break;
		
	    case CCheckPoint:
		printf("Making a Checkpoint.\n\r");
		Checkpoint();
		break;
		
	    
	    default:
		printf("Internal Error:  Bad cmd type %d.\n\r", (int) cmd);
		break;
	  }
      }

    Quit();
  }

/*
 *  This dummy main procedure allocates a larger stack and invokes
 *  'realmain'.
 */
 
main()
  {
# ifdef VAX
    realmain();
# else
    Process_id pid;
    Message msg;
    
    pid = Create( 5, realmain, 0x4000 );
    Ready( pid, 0 );
    
    ReceiveSpecific( msg, pid );
    Quit(msg[0]);
# endif
  }
