/*
 * Timing package.
 * Used to print out relative times for events.
 */

#include "Venviron.h"
#include "Vio.h"

int t1, t2, c1, c2;
int T0, C0, T1, C1;
File *f;


/*
 * InitTimingPackage:
 * Initializes the timing package.
 * Can be called repeated to reset the timing variables.
 */

InitTimingPackage(fp)
    File *fp;
  {
    t1 = GetTime(&c1);
    T0 = t1;
    C0 = c1;
    f = fp;
  }


/*
 * MarkTime:
 * Prints a string and the time in clicks since the last time that either
 * InitTimingPackage or MarkTime were called.
 */

MarkTime(str)
    char *str;
  {
    t2 = GetTime(&c2);
    fprintf(f, "%s: %d\n", str, (t2-t1)*100 + (c2-c1));
    fflush(f);
    t1 = GetTime(&c1);
  }


/*
 * ElapsedTime:
 * Returns the elapsed time since the last call to InitTimingPackage in clicks.
 */

int ElapsedTime()
  {
    int t, c;

    t = GetTime(&c);
    return((t-T0)*100 + (c-C0));
  }
