/* Screen support for MetaFont84.
 * Graphics interface to SUN running:
 * - V system VGTS, if the Vsystem switch is set, else:
 * - SunWindows window system, under Unix 4.2.
 * Per Bothner. March 1984.
 */
#define NULL 0
#include <stdio.h>

#ifdef Vsystem

#include <Vgts.h>
#include <framebuf.h>
#include <bitmaps.h>
#define TopItem 1
#define RasterItem 2
#define xOffsetMax 1024
short sdf = -1, vgt, xOffset = xOffsetMax, yOffset = 1024;
MemRaster *r = NULL, *SubRaster();
/* (0, 0) is top left corner */
long GXBase = 0; /* So linker doesn't complain when loading libgraphics */
#define FreeMemRaster(r) {FreeRaster(r); free(r); }
#define ResetRaster()							\
	{if (r && r->where&LinkedRaster) {FreeRaster(r); free(r);}	\
	 r = NULL;}
freescreen()
  {
    if (sdf >= 0)
      {
	DeleteVGT(vgt,1);
	DeleteSDF(sdf);
	sdf = -1;
      }
  }
Quit()
  {
    freescreen();
    exit(-1);
  }
#else

#include <sys/types.h>
#include "pixrect/pr_util.h"
#include "pixrect/pixrect.h"
#include "sunwindow/rect.h"
#include "sunwindow/rectlist.h"
#include "sunwindow/pixwin.h"
#include "suntool/gfxsw.h"
#include "pixrect/memvar.h"

struct gfxsubwindow *gfx;

#endif

initscreen(x)
  {
#ifdef Vsystem
    if (sdf < 0)
      {
	sdf = CreateSDF();
	DefineSymbol(sdf, TopItem, 0);
	EndSymbol(sdf, TopItem, 0);
	vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, TopItem, "MetaFont");
	fprintf(stderr, "\r\n[Use the mouse to position a view]\r\n");
	fflush(stdout); RedrawPad(stdout);
	DefaultView(vgt, 400, 420, -4, -400, 0, 0, 0, 0);
      }
    ResetRaster();
#else
    gfx = gfxsw_init(0, NULL);
    gfxsw_getretained(gfx);
    return -1;
#endif
  }

blankrectangle(leftCol, rightCol, topRow, botRow)
  { int dx, dy, h, w;
#ifdef Vsystem
    MemRaster s;
    if (r == NULL) return;
    dx = leftCol - xOffset;
    dy = topRow - yOffset;
    if (dx < 0) {leftCol = xOffset; dx = 0; }
    if (dy < 0) { topRow = yOffset; dy = 0; }
    h = botRow-topRow;
    w = rightCol-leftCol;
    if (w > r->width) w = r->width;
    if (h > r->height) h = r->height;
    SubRaster(&s, r, dx, dy, h, w);
    RasterOp(&s, 0, GXclear);
    FreeRaster(&s);

#else
    pw_writebackground(gfx->gfx_pixwin, leftCol, topRow,
        rightCol - leftCol, botRow - topRow, PIX_CLR);
#endif
  }

#define RowSize 1024	/* should be multiple of 16 */
static u_short RowBits[RowSize >> 4];
#ifndef Vsystem
mpr_static(Row, RowSize, 1, 1, RowBits);
#endif
static u_short ClearMask[17] = {
    0, 0x8000, 0xC000, 0xE000, 0xF000, 0xF800, 0xFC00, 0xFE00,
    0xFF00, 0xFF80, 0xFFC0, 0xFFE0, 0xFFF0, 0xFFF8, 0xFFFC, 0xFFFE, 0xFFFF};
static u_short SetMask[17] = {
    0xFFFF, 0x7FFF, 0x3FFF, 0x1FFF, 0xFFF, 0x7FF, 0x3FF, 0x1FF,
    0xFF, 0x7F, 0x3F, 0x1F, 0xF, 0x7, 0x3, 0x1, 0};

paintrow(row, color, transitions, lastCol)
    int *transitions /* [0..lastCol] */;
  {
    register int *stepPtr = transitions;
    register *lastStep = stepPtr + lastCol;
    register step = *stepPtr;
    register u_short *word = RowBits + (step>>4);
    if (!color) stepPtr++;
    for (;;)
      { register u_short *nextWord;
	/* clear */
	*word &= ClearMask[step & 15];
	if (stepPtr > lastStep) break;
	step = *stepPtr++;
	nextWord = RowBits + (step>>4);
	while (word < nextWord) *++word = 0;
	/* set */
	*word |= SetMask[step & 15];
	if (stepPtr > lastStep) break;
	step = *stepPtr++;
	nextWord = RowBits + (step>>4);
	while (word < nextWord) *++word = 0xFFFF;
      }
#ifdef Vsystem
  { register u_short *rowWord; u_short *lastWord; /* should be reg. */
    int xShift, xSize;
#define YgridPow 6
#define Ygrid (1<<YgridPow)
#define XgridPow YgridPow
#define Xgrid (1<<XgridPow)
    xShift = *transitions - xOffset;
    if (xShift >= 0) xShift = 0;
    else xShift = (xShift >> XgridPow) << XgridPow; /* truncate to -Infinity */
    xSize = *lastStep - xOffset;
    if (r != NULL && xSize < r->width) xSize = r->width;
    xSize = ((xSize  - xShift + (Xgrid - 1)) >> XgridPow) << XgridPow;
    if (r == NULL)
      {
	yOffset = row & ~(Ygrid-1);
	r = SubRaster(0, 0, 0, 0, 2*Ygrid, xSize);
      }
    else if ((step = row - yOffset) < 0)
      { MemRaster *tmp;
	step >>= YgridPow; /* truncates to -Infinity */ step <<= YgridPow;
	tmp = SubRaster(0, r, xShift, step, r->height - step, xSize);
	FreeMemRaster(r); r = tmp; yOffset += step;
      }
    else if (step >= r->height)
      { MemRaster *tmp;
	step += Ygrid - 1; step >>= YgridPow; step <<= YgridPow;
	tmp = SubRaster(0, r, xShift, 0, step, xSize);
	FreeMemRaster(r); r = tmp;
      }
    else if (xShift != 0 || xSize > r->width)
      { MemRaster *tmp = SubRaster(0, r, xShift, 0, r->height, xSize);
	FreeMemRaster(r); r = tmp;
      }
    xOffset += xShift;
    word = r->start + row - yOffset
      + ((transitions[0] - xOffset) >> 4) * r->stride;
    rowWord = RowBits + (transitions[0] >> 4);
    lastWord = RowBits + (*lastStep >> 4);
    step = ClearMask[transitions[0]&15];
    if (rowWord < lastWord)
      {
	*word = (*word & step) | (*rowWord & ~step);
	step = r->stride;
	for (rowWord++; word+=step, rowWord < lastWord;) *word = *rowWord++;
	step = 0;
      }
    step |= SetMask[*lastStep & 15];
    *word = (*word & step) | (*rowWord & ~step);
  }
#else
    pw_write(gfx->gfx_pixwin, transitions[0], row,
        *lastStep - transitions[0], 1, PIX_SRC, &Row, transitions[0], 0);
#endif
  }

updatescreen()
  {
#ifdef Vsystem
    EditSymbol(sdf, TopItem);
    DeleteItem(sdf, RasterItem);
    if (r != NULL)
	AddItem(sdf, RasterItem,
	    xOffset + 1, xOffset + r->width,
	    - yOffset - r->height, - yOffset - 1,
	    0, SDF_RASTER, r->start);
    EndSymbol(sdf, TopItem, vgt);
#else
    printf("{Update:%d}",gfx->gfx_flags);
    if (gfx->gfx_flags & GFX_DAMAGED) gfxsw_handlesigwinch(gfx);
#endif
  }
