#ifndef lint
static char sccsid[] = "@(#)tty.c	2.7 (Berkeley) 8/11/83";
#endif

/*
 * Mail -- a mail program
 *
 * Generally useful tty stuff V sersion.
 */

#include "rcv.h"

static	int	c_erase;		/* Current erase char */
static	int	c_kill;			/* Current kill char */
static	int	hadcont;		/* Saw continue signal */
static	jmp_buf	rewrite;		/* Place to go when continued */

/*
 * Read all relevant header fields.
 */

grabh(hp, gflags)
	struct header *hp;
{
	int ttycont(), signull();
	int (*savecont)();
	register int s;
	int errs;

	errs = 0;

	if (gflags & GTO) {
		hp->h_to = readtty("To: ", hp->h_to);
		if (hp->h_to != NOSTR)
			hp->h_seq++;
	}
	if (gflags & GSUBJECT) {
		hp->h_subject = readtty("Subject: ", hp->h_subject);
		if (hp->h_subject != NOSTR)
			hp->h_seq++;
	}
	if (gflags & GCC) {
		hp->h_cc = readtty("Cc: ", hp->h_cc);
		if (hp->h_cc != NOSTR)
			hp->h_seq++;
	}
	if (gflags & GBCC) {
		hp->h_bcc = readtty("Bcc: ", hp->h_bcc);
		if (hp->h_bcc != NOSTR)
			hp->h_seq++;
	}
	return(errs);
}

/*
 * Read up a header from standard input.
 * The source string has the preliminary contents to
 * be read.
 *
 */

char *
readtty(pr, src)
	char pr[], src[];
{
	char ch, buf[BUFSIZ];
	int c, signull();
	register char *cp;

	fputs(pr, stdout);
	fflush(stdout);
	if (src) EditLine(stdout,src,strlen(src) );
	fgets(buf, BUFSIZ, stdin);
	cp = rindex(buf,'\n');
	if (cp) *cp = 0;
	if (equal("", buf))
		return(NOSTR);
	return(savestr(buf));
}


/*
 * Null routine to satisfy
 * silly system bug that denies us holding SIGCONT
 */
signull(s)
{}

chmod(file,mode)
{}

getuid()
  { return(0); }

getpid()
  { return(GetPid(ACTIVE_PROCESS,ANY_PID)); }


File *CreateFile(name,mode)
    char *name;
  {
	/*
	 * create a file and return the file descriptor for writing.
	 * We use this to create protected files, since I know of no
	 * way to really do this under Unix.
	 */
    File *fad[2], *wanted;
    SystemCode error;
    char modeString[10];
    char *args[3], result[512];
    
    wanted = Open(name,FCREATE,&error);
    sprintf(modeString,"0%o",mode);
    args[0] = modeString;
    args[1] = name;
    args[2] = NULL;
    if (error = RemoteExecute( fad, "chmod", args, FREAD ) )
      {
        if (debug) printf("Error on chmod %s %s command: %s\n", 
			modeString, name, ErrorString(error) );
	return(wanted);
      }
    if (fgets(result,sizeof(result),fad[0])==NULL)
      strcpy(result,"");
    if (debug)
      printf("Read %s from command chmod %s %s\n",result, modeString,name );
    Close(fad[0]);
    return(wanted);
  }


VSendMail(list,mtf,hp)
    char **list;
    File *mtf;
    struct header *hp;
  {
	/*
	 * Function to actually send the mail on the Vsystem.
	 * We open an FEXECUTE pipe to the sendmail command on the vax.
	 */
    register char **t;
    File *fad[2];
    SystemCode error;
    char *cmd = "/usr/lib/sendmail";
    char result[512];
    register temp;

    if (error = RemoteExecute( fad, cmd, list+1, FCREATE ) )
      {
        printf("Error on %s command: %s\n", cmd, ErrorString(error) );
	return;
      }
   printf("Message being sent...\n");
   rewind(mtf);
   puthead(hp, fad[1], GTO|GSUBJECT|GCC|GNL);
   while ((temp = getc(mtf)) != EOF)
     {
       putc(temp,fad[1]);
     }
   fprintf(fad[1],".\n");
   Close(fad[1]);
   if (fgets(result,sizeof(result),fad[0])==NULL)
      strcpy(result,"");
   else if (debug) printf("Error on %s: %s", cmd, result);
   Close(fad[0]);
  }


StringFromCommand(cmd, result, n)
    char *cmd, *result;
  {
    CommandWithArg(cmd,NULL,result,n);
  }


CommandWithArg(cmd, arg, result, n)
    char *cmd, *arg, *result;
  {
    File *fad[2];
    SystemCode error;
    char *p;
    char *args[3];
    
    args[0] = arg;
    args[1] = NULL;
    if (error = RemoteExecute( fad, cmd, args, FREAD ) )
      {
        printf("Error on %s command: %s\n", cmd, ErrorString(error) );
        strcpy("",result);
	return;
      }
    if (fgets(result,n,fad[0])==NULL)
      strcpy(result,"");
    p = rindex(result,'\n');
    if (p) *p = 0;
    if (debug)
      printf("Read string %s from command %s %s\n",result,cmd,arg?arg:"");
    Close(fad[0]);
  }

link(a,b)
    char *a, *b;
  {
     /*
      * link a file by invoking the Unix command
      */
    File *fad[2];
    SystemCode error;
    char *p;
    char *args[3], result[512];
    
    args[0] = a;
    args[1] = b;
    args[2] = NULL;
    if (error = RemoteExecute( fad, "ln", args, FREAD ) )
      {
        if (debug) printf("Error on ln %s %s command: %s\n", 
			a,b, ErrorString(error) );
	return(-1);
      }
    if (fgets(result,sizeof(result),fad[0])==NULL)
      strcpy(result,"");
    p = rindex(result,'\n');
    if (p) *p = 0;
    if (debug)
      printf("Read string %s from ln %s %s\n",result,a,b);
    Close(fad[0]);
    return(strlen(result) ? -1 : 0);
  }

gethostname(host, size)
     char *host;
     int size;
  {
     StringFromCommand("hostname", host, size);
     if (strlen(host)) return;
     printf("Your current context should be a Unix server!\n");
     exit(1);
  }


Invoke(prog,arg)
    char *prog, *arg;
  {
    /*
     * Invoke the V program on the given argument
     */
    char *args[3];
    SystemCode error;
    ProcessId pid;
    int status;

    args[0] = prog;
    args[1] = arg;
    args[2] = NULL;
    printf("Invoking %s on %s...\n", prog, arg);
    pid = ExecProgram(args, NULL, NULL, NULL, &status, &error);
    if (pid == 0)
      {
        printf("Error running  %s: %s\n", prog, ErrorString(error) );
	return;
      }
    Wait(pid, &status);
  }

