/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/* Forward function declarations */

char *inet_ntoa();


/*
 * Print out a name descriptor in an aesthetically pleasing format.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vgts.h>
#include <Vdirectory.h>
#include <Vnet.h>
#include <Vstorage.h>


static char *FormatDate();
 
PrintDescriptor( desc, bannertype )
    register ArbitraryDescriptor *desc;
    register int *bannertype; 
/*
 * Each descriptor has an associated banner defined by this routine.
 * If "bannertype" is not the same as "desc->e.descriptortype" then
 * this routine will output the banner for this type.  
 */
  {
    unsigned short mode, i;

    switch (desc->e.descriptortype)
      {
	case EMPTY_DESCRIPTOR:
	    break;

	case CONTEXT_DESCRIPTOR:
	    if ( *bannertype != CONTEXT_DESCRIPTOR )
	      {
		printf("\n%-19s  %-32.32s\n", " ContextId", "Name");
		*bannertype = CONTEXT_DESCRIPTOR;
	      }
	    printf("(%08x,%08x)  %-32.32s\n",
		    desc->c.ctxpair.pid, desc->c.ctxpair.cid, desc->c.name);
	    break;

	case FILE_DESCRIPTOR:
            if( *bannertype != FILE_DESCRIPTOR )
              {
                printf("\n%-16s %9s %s %-32.32s\n", "   Mode","Size",
                        " Last Modified","Name");
                *bannertype = FILE_DESCRIPTOR;
              }

            putchar((desc->f.perms)&SS_DIR ? 'd': '-');
            for( i = 1; i <= 3; ++i )
              {
                putchar((desc->f.perms)&SS_READ ? 'r': '-');
                putchar((desc->f.perms)&SS_WRITE ? 'w': '-');
                putchar((desc->f.perms)&SS_EXECUTE ? 'e': '-');
                putchar((desc->f.perms)&SS_LIST ? 'l': '-');
                putchar((desc->f.perms)&SS_MODIFY ? 'm': '-');

                desc->f.perms = (desc->f.perms) >> 5;
              }
            printf("   %7d %s %-32.32s\n", desc->f.size, 
                        FormatDate( desc->f.timestamp ),desc->f.name ); 
	    break;

	case TEAM_DESCRIPTOR:
	    if (*bannertype != TEAM_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-32.32s %10s %10s\n", "File name",
		    "OwnerPid", "RootPid");
		*bannertype = TEAM_DESCRIPTOR;
	      }

	    printf("%-32.32s %10x %10x\n", desc->t.fileName, 
		    desc->t.ownerPid, desc->t.rootPid);
	    break;

	case HOST_DESCRIPTOR:
	    if (*bannertype != HOST_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-15s %-15s %10s %15s\n", "User","Host name",
		    "TeamServer", "Availability");
		*bannertype = HOST_DESCRIPTOR;
	      }

	    printf("%-15s %-15s %10x %15x\n", desc->h.userName, 
	    		desc->h.hostName,
			desc->h.regPid, desc->h.availability);
	    break;

	case DEVICE_DESCRIPTOR:
	    if (*bannertype != DEVICE_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\n%-32.32s %10s\n", "Device name", 
		    "Unit");
		*bannertype = DEVICE_DESCRIPTOR;
	      }

	    printf("%-32.32s %10d\n", desc->d.name,
		desc->d.unit);
	    break;

	case UNIXFILE_DESCRIPTOR:
	    if (*bannertype != UNIXFILE_DESCRIPTOR)
	      {
            /* -rw-r--r--   1  nagler   netgraph  25808  8/07/83 02:32 list */ 
    printf( "\n   Mode   Links Owner    Group      Size %s Name\n",
			FormatDate( -1 ) );
		*bannertype = UNIXFILE_DESCRIPTOR;
	      }

	    mode = desc->u.st_mode;

	    /* Print out type of file and protection mode bits */
	    switch (mode & S_IFMT)
	      {
	        case S_IFDIR:	putchar('d'); break;
	        case S_IFCHR:	putchar('c'); break;
		case S_IFBLK:	putchar('b'); break;
		case S_IFREG:	putchar('-'); break;
		case S_IFLNK:	putchar('l'); break;
		case S_IFSOCK:	putchar('s'); break;
		default:	putchar('?'); break; /* illegal */
	      }
	    putchar(mode&S_IREAD ? 'r' : '-');
	    putchar(mode&S_IWRITE ? 'w' : '-');
	    switch (mode & (S_IEXEC|S_ISUID))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC:	putchar('x'); break;
		case S_ISUID:	putchar('S'); break; /* anomaly */
		default:	putchar('s'); break;
	      }
	    putchar(mode&(S_IREAD>>3) ? 'r' : '-');
	    putchar(mode&(S_IWRITE>>3) ? 'w' : '-');
	    switch (mode & ((S_IEXEC>>3)|S_ISGID))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC>>3:putchar('x'); break;
		case S_ISGID:	putchar('S'); break; /* anomaly */
		default:	putchar('s'); break;
	      }
	    putchar(mode&(S_IREAD>>6) ? 'r' : '-');
	    putchar(mode&(S_IWRITE>>6) ? 'w' : '-');
	    switch (mode & ((S_IEXEC>>6)|S_ISVTX))
	      {
		case 0:		putchar('-'); break;
		case S_IEXEC>>6:putchar('x'); break;
		case S_ISVTX:	putchar('T'); break; /* strange */
		default:	putchar('t'); break;
	      }

	    printf("  %2d  %-8.8s %-8.8s%7d %s %s\n", desc->u.st_nlink,
		desc->u.ownername,
		desc->u.groupname,
		desc->u.st_size,
		FormatDate(desc->u.st_mtime), 
		desc->u.name );
	    break;


	case VGT_DESCRIPTOR:
	    if (*bannertype != VGT_DESCRIPTOR)
	      {
		/* Generate a banner */
		printf("\nVGT Lines Columns Owner  %-14s %10s\n", "Name", 
		    "Banner");
		*bannertype = VGT_DESCRIPTOR;
	      }

	    printf("%2d", desc->v.vgt);
	    if (desc->v.typeVGT & TTY)
	        printf("   %3d  %3d ", desc->v.lines, desc->v.columns );
	    else 
	        printf("    Graphics");		
	    if (desc->v.ownerPid)
	        printf("  %8x ", desc->v.ownerPid );
	    else 
	        printf("           ");
	    printf("%-14s %-40s\n", desc->v.name, desc->v.banner);
	    break;

	case INTERNET_DESCRIPTOR:
	    if (*bannertype != INTERNET_DESCRIPTOR)
	      {
		printf("\n%-30s %15s %15s\n",
		    "Connection Type", "From", "To");
		*bannertype = INTERNET_DESCRIPTOR;
	      }
	    printf("%-30s ", desc->i.name);
	    switch (desc->i.typeInternet)
	      {
		case GTWtype:
		case TCPtype:
		    printf("%15s ", inet_ntoa(desc->i.addr1));
		    printf("%15s\n", inet_ntoa(desc->i.addr2));
		    break;
		case ICMPtype:
		case IPtype:
		    printf("%15s\n", inet_ntoa(desc->i.addr1));
		    break;
		case PUPtype:
		    printf("           %04o\n", desc->i.addr1);
		    break;
		default:
		    printf("%15s %15s\n", "?", "?");
		    break;
	      }
	    break;

	default:
	    printf("\nUnknown descriptor type: %d\n", desc->e.descriptortype);
	    break;
      }
  } /* PrintEntry */


static char *FormatDate(clock)
    long clock;
/*
 * Create a fixed width string for the date specified by "clock"
 */
  {
    extern struct tm *localtime();
    static char date[ 20 ];
    register struct tm *time;

    if ( clock == -1 )
        return( " Last Modified" );	/* must be same length as "date" */
    else if ( clock == 0 )
        return( "              " );	/* must be same length as "date" */
    else
      {
        time = localtime(&clock);
    
        sprintf( date, "%2d/%02d/%02d %02d:%02d", time->tm_mon+1,
	    time->tm_mday, time->tm_year % 100, time->tm_hour, time->tm_min );
        return ( date );
      }
  } /* FormatDate */


/*
 * Print a descriptor in short form -- usually just the name.
 */
ShortPrintDescriptor(desc, fl)
    register ArbitraryDescriptor *desc; 
    int fl ; /* field length */
  {
    if( ! desc )
      {
        /* print blank */
	printf("%-*.*s", fl, fl, " ");
	return ;
      }

    switch (desc->e.descriptortype)
      {
        case EMPTY_DESCRIPTOR:
	    break;

	case FILE_DESCRIPTOR:
	    if( desc->f.perms & SS_DIR )
	        strcat( desc->f.name, "/") ;
	    printf("%-*.*s", fl, fl, desc->f.name);
	    break;

	case UNIXFILE_DESCRIPTOR:
	    if( (desc->u.st_mode&S_IFMT) == S_IFDIR ) 
	        strcat( desc->f.name, "/") ;
	    printf("%-*.*s", fl, fl, desc->f.name);
	    break;

	case CONTEXT_DESCRIPTOR:
	    strcat( desc->f.name, "/") ;
	    printf("%-*.*s", fl, fl, desc->c.name);
	    break;

	case DEVICE_DESCRIPTOR:
	case TEAM_DESCRIPTOR:
	case INTERNET_DESCRIPTOR:
	    printf("%-*.*s", fl, fl, desc->f.name);
	    break;

	case VGT_DESCRIPTOR:
	    printf("%-*.*s", fl, fl,  desc->v.name);
	    break;

	case QUEUE_DESCRIPTOR:
	    printf("%-*.*s", fl, fl,  desc->q.filename);
	    break;

        case HOST_DESCRIPTOR:
	    printf("%-*.*s", fl, fl,  desc->h.hostName);
	    break;

	default:
	    printf("Unknown type %-*.*s", fl, fl, " "); 
	    break;
      }
  }


/* Following should appear in separate V internet libraries (someday) */

/* internet address structures */

/*
 * inet_ntoa:
 * Convert an internet address to standard 4-part character string.
 */
char *inet_ntoa(ad)
    unsigned long ad;
  {
    static char b[18];

    sprintf(b, "%d.%d.%d.%d",
	    (unsigned char)((ad&0xFF000000)>>24),
	    (unsigned char)((ad&0x00FF0000)>>16),
	    (unsigned char)((ad&0x0000FF00)>>8),
	    (unsigned char) (ad&0x000000FF));
    return (b);
  }


/*
 * returns length of name.
 */
namelength(desc)
    register ArbitraryDescriptor *desc;
  {

    switch (desc->e.descriptortype)
      {
        case EMPTY_DESCRIPTOR:
	    return( 0 ) ;

	case FILE_DESCRIPTOR:
	case UNIXFILE_DESCRIPTOR:
	case DEVICE_DESCRIPTOR:
	case TEAM_DESCRIPTOR:
	case INTERNET_DESCRIPTOR:
	case CONTEXT_DESCRIPTOR:
	     return( strlen(desc->f.name) ) ;

	case VGT_DESCRIPTOR:
 	     return( strlen(desc->v.name) ) ;

	case QUEUE_DESCRIPTOR:
	    return( strlen(desc->q.filename) ) ;

        case HOST_DESCRIPTOR:
	    return( strlen(desc->h.hostName) ) ;

	default:
	    return( 13 ) ;
      }
  }

