
#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vdirectory.h>

extern int ReadDirectory();
extern CompareDescriptors();

/*
 ***************************************************************************
 *                     R e a d D i r e c t o r y                           *
 ***************************************************************************
 */
int ReadDirectory( dirName, DescriptorList, listLen, error )
    char *dirName;
    ArbitraryDescriptor *DescriptorList[];
    int listLen;
    SystemCode *error;
/*
 * Read the contents of the directory and put all non EmptyDescriptors
 * in the DescriptorList.
 * returns the number of entries or -1 if an error in opening and
 * -2 on a read error.
 */
  {
    register int i = 0;
    register ArbitraryDescriptor *desc;
    register File *serverFile;
    int lastdesc = 0;
    int size;
    
    /*
     * Interact with the server.
     */
    serverFile = Open(dirName, FREAD|FDIRECTORY|FBLOCK_MODE, error);

    if ( *error )
      {
        return( -1 );	/* error will be seen by caller since it is global */
      }

   

    /* Protect ourselves against brain-damaged servers */
    if (serverFile->blocksize > sizeof(ArbitraryDescriptor))
        size = sizeof(ArbitraryDescriptor);
    else
        size = serverFile->blocksize;

    do 
      {
	/* load up the Descriptor list */
	desc = (ArbitraryDescriptor *) malloc(sizeof(ArbitraryDescriptor));

        if ( Read( serverFile, desc, size ) == size )
	  {
	    if ( desc->e.descriptortype != EMPTY_DESCRIPTOR )
	      {
		DescriptorList[lastdesc++] = desc;
		if (lastdesc > listLen)
		  {
		    fprintf(stderr, "ReadDir: directory too long to sort\n");
		  }
	      }
	    serverFile->block++;
	  }
	else
	   break;	/* an error has occurred */
      }
    while ( (serverFile->lastexception == OK) && (lastdesc <= listLen) );


    if ( (*error = serverFile->lastexception) != END_OF_FILE )
      {
        printf( "Error reading directory block #%d: %s\n", serverFile->block
		, ErrorString( *error ) );
        Close(serverFile);
	return (lastdesc); /* was -2... test mjz */	
      }
    Close(serverFile);


    /* sort directory */
    qsort(DescriptorList, lastdesc, sizeof(ArbitraryDescriptor *), 
    	CompareDescriptors);

    return( lastdesc );

  } /* ReadDirectory */

/*
 ***************************************************************************
 *                    F r e e D e s c r i p t o r                          *
 *-------------------------------------------------------------------------*
 * Free memory associated with the descriptors...                          *
 ***************************************************************************
 */
FreeDescriptor( DescriptorList, num )
    ArbitraryDescriptor *DescriptorList[];
    int num;				/* number of descriptors to free */
  {
    register int i;

    for (i = 0; i < num; i++)
      {
	free(DescriptorList[i]);
      }
  }

/***************************************************************************
 *                    C o m p a r e   D e s c r i p t o r s                *
 *-------------------------------------------------------------------------*
 * Compare two descriptors and return <0, 0, or >0 depending on            *
 *  whether the first is less than, equal to, or greater than              *
 *  the second in sorted order.						   *
 ***************************************************************************
 */
CompareDescriptors(d1, d2)
    ArbitraryDescriptor **d1, **d2;
  {
    register ArbitraryDescriptor *desc1 = *d1;
    register ArbitraryDescriptor *desc2 = *d2;
    register int diff;

    if ((diff = desc1->e.descriptortype - desc2->e.descriptortype) != 0)
        return (diff);

    switch (desc1->e.descriptortype)
      {
	case EMPTY_DESCRIPTOR:
	    return (0);

	case FILE_DESCRIPTOR:
	case UNIXFILE_DESCRIPTOR:
	case CONTEXT_PREFIX_DESCRIPTOR:
	case DEVICE_DESCRIPTOR:
	case TEAM_DESCRIPTOR:
	case LINK_DESCRIPTOR:
	case INTERNET_DESCRIPTOR:
	    return (strncmp(desc1->f.name, desc2->f.name, MAX_NAME_LENGTH));

	case VGT_DESCRIPTOR:
	    return (desc1->v.fileid - desc2->v.fileid);

	case QUEUE_DESCRIPTOR:
	    return (desc1->q.rank - desc2->q.rank);

        case HOST_DESCRIPTOR:
	case PIDMAP_DESCRIPTOR:
	default:
	    return (0);	/* don't know how to sort these */

      }
  }
