/****************************************************************************
 *	CS 246 - Advanced Operating Systems				    *
 *	Robert Neilon							    *
 *	Madhavan Srinivasan						    *
 *	Matthew Zekauskas						    *
 ****************************************************************************/
/* MenuHit()
 * 	Called if an item from the menu bar is selected.  Menuhit brings up
 *	the appropriate popup menu.  If a command in the popup menu was
 *	selected, DialogDriver is called to execute the command.  Otherwise,
 *	the global screen refresh flag is turned off before returning to the
 *	caller.
 */

#include <Venviron.h>
#include <Vgts.h>
#include <Vio.h>
#include "iconstants.h"			/* Iconic interface global constants */

#define  OUTSIDE_OF_MENU  -1

extern   int  ScreenRefresh;		/* Global screen refresh flag */

/* Pop up menu for menu item "File" */
static PopUpEntry FileMenu[] =
{
"        cd      ", CD_CMD,
"        copydir ", COPYDIR_CMD,
"        cp      ", CP_CMD,
"        define  ", DEFINE_CMD,
"        fscheck ", FSCHECK_CMD,
"        ftp     ", FTP_CMD,
"        type    ", TYPE_CMD,
"        undefine", UNDEFINE_CMD,
0,0
};

/* Pop up menu for menu item "Network" */
static PopUpEntry NetworkMenu[] =
{
"     internetserver", INTERNETSERVER_CMD,
"     iptelnet      ", IPTELNET_CMD,
"     iptn          ", IPTN_CMD,
"     telnet        ", TELNET_CMD,
"     tn            ", TN_CMD,
0,0
};

/* Pop up menu for menu item "Status" */
static PopUpEntry StatusMenu[] =
{
"      biopsy      ", BIOPSY_CMD,
"      query       ", QUERY_CMD,
"      storagestats", STORAGESTATS_CMD,
0,0
};

/* Pop up menu for menu item "System" */
static PopUpEntry SystemMenu[] =
{
"       date      ", DATE_CMD,
"       destroy   ", DESTROY_CMD,
"       dopar     ", DOPAR_CMD,
"       doseq     ", DOSEQ_CMD,
"       fexecute  ", FEXECUTE_CMD,
"       iphost    ", IPHOST_CMD,
"       serial    ", SERIAL_CMD,
"       stuffboot ", STUFFBOOT_CMD,
"       testexcept", TESTEXCEPT_CMD,
"       timekernel", TIMEKERNEL_CMD,
0,0
};

/* Pop up menu for menu item "Utilities" */
static PopUpEntry UtilitiesMenu[] =
{
"          bits ", BITS_CMD,
"          dale ", DALE_CMD,
"          debug", DEBUG_CMD,
"          draw ", DRAW_CMD,
"          echo ", ECHO_CMD,
"          show ", SHOW_CMD,
0,0
};

/* Pop up menu for menu item "Games" */
static PopUpEntry GamesMenu[] =
{
"        amaze   ", AMAZE_CMD,
"        checkers", CHECKERS_CMD,
0,0
};

/* MenuHit () */
MenuHit(menuItem, fileName, fileType)
short menuItem;			/* number of menu item selected */
char fileName[];		/* file already selected (if any) */
FileType fileType;		/* type of this file */
	 /* ...ugly C case dependence - mjz */
{
	short code;		/* return code from pop up menu */

	/* bring up apprpriate pop up menu based on menu item selected */
	switch (menuItem)
	{
		case MENU_FILE:
		    printf("File menu ");
		    code = popup(FileMenu);
		    break;
		case MENU_NETWORK:
                    printf("Network menu ");
		    code = popup(NetworkMenu);
		    break;
		case MENU_STATUS:
		    printf("Status menu ");
		    code = popup(StatusMenu);
		    break;
		case MENU_SYSTEM:
		    printf("System menu ");
		    code = popup(SystemMenu);
		    break;
		case MENU_UTILITIES:
		    printf("Utilities menu ");
		    code = popup(UtilitiesMenu);
		    break;
		case MENU_GAMES:
		    printf("Games menu ");
		    code = popup(GamesMenu);
		    break;
		case MENU_OTHER:
		    printf("Other menu ");
		    code = CMD_OTHER;
		    break;
		}
	printf(", item  %d\n\r\r", code);

	/* if an item (command) was selected, pass it on to DialogDriver */
	if (code != OUTSIDE_OF_MENU)
	    DialogDriver(code,fileName,fileType);

	/* otherwise, turn screen refresh off and return */
	else
	    ScreenRefresh = REFRESH_OFF;
}
