/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Advanced OS			*/
/* V-System Iconic User Interface	*/
/****************************************/

/*
 * Global include file:  iconstants.h
 */

/*
 * Assigned item numbers 
 */

/* Menu bar items (11-20) */

#define MENU_LOWLIMIT	11		/* lowest menu item number */
#define MENU_HIGHLIMIT	17		/* highest menu item number */

#define MENU_FILE	11
#define MENU_NETWORK	12
#define MENU_STATUS	13
#define MENU_SYSTEM	14
#define MENU_UTILITIES	15
#define MENU_GAMES	16
#define	MENU_OTHER	17		/* a command to type in */

/* icon items (21-30) */

#define ICON_LOWLIMIT	21		/* lowest icon item number */
#define ICON_HIGHLIMIT	29		/* highest icon item number */

#define HELP_ICON	ICON_LOWLIMIT		/* 21 */
#define LISTDIR_ICON	HELP_ICON+1
#define EDITOR_ICON	LISTDIR_ICON+1
#define CCOMPILER_ICON	EDITOR_ICON+1
#define EXECUTE_ICON	CCOMPILER_ICON+1	/* 25 */
#define PRINTER_ICON	EXECUTE_ICON+1
#define LOGOUT_ICON	PRINTER_ICON+1
#define TRASH_ICON	LOGOUT_ICON+1
#define PUNT_ICON	TRASH_ICON+1		/* 29 */

/* file icon items (31-?) */

#define BLANK_FILE_ICON	31		/* file with user selectable name */
#define FILE_SCROLLUP	32		/* move towards top */
#define FILE_SCROLLDOWN	33		/* move towards bottom */
#define FILE_CONTEXT	34		/* context message */
#define FILE_WAITING	35		/* for reassuring icon */
#define FILE_LOWLIMIT	36		/* MUST be EVEN!!!! */
#define NO_OF_FILES	30		/* Max files allowed on screen */
/* allow 2 item numbers for each file; one for icon, one for name */
#define FILE_HIGHLIMIT	FILE_LOWLIMIT + (2*NO_OF_FILES)


/* pop up menu commands */

#define CMD_LOWLIMIT		101
#define CMD_HIGHLIMIT		135

#define AMAZE_CMD		CMD_LOWLIMIT	/* 101 */
#define BIOPSY_CMD		AMAZE_CMD+1
#define BITS_CMD		BIOPSY_CMD+1
#define CD_CMD			BITS_CMD+1
#define CHECKERS_CMD		CD_CMD+1	/* 105 */
#define COPYDIR_CMD		CHECKERS_CMD+1
#define CP_CMD			COPYDIR_CMD+1
#define DALE_CMD		CP_CMD+1
#define DATE_CMD		DALE_CMD+1
#define DEBUG_CMD		DATE_CMD+1	/* 110 */
#define DEFINE_CMD		DEBUG_CMD+1
#define DESTROY_CMD		DEFINE_CMD+1
#define DOPAR_CMD		DESTROY_CMD+1
#define DOSEQ_CMD		DOPAR_CMD+1
#define DRAW_CMD		DOSEQ_CMD+1	/* 115 */
#define ECHO_CMD		DRAW_CMD+1
#define FEXECUTE_CMD		ECHO_CMD+1
#define FSCHECK_CMD		FEXECUTE_CMD+1
#define FTP_CMD			FSCHECK_CMD+1
#define INTERNETSERVER_CMD	FTP_CMD+1	/* 120 */
#define IPHOST_CMD		INTERNETSERVER_CMD+1
#define IPTELNET_CMD		IPHOST_CMD+1
#define IPTN_CMD		IPTELNET_CMD+1
#define QUERY_CMD		IPTN_CMD+1
#define SERIAL_CMD		QUERY_CMD+1	/* 125 */
#define SHOW_CMD		SERIAL_CMD+1
#define STORAGESTATS_CMD	SHOW_CMD+1
#define STUFFBOOT_CMD		STORAGESTATS_CMD+1
#define TELNET_CMD		STUFFBOOT_CMD+1
#define TESTEXCEPT_CMD		TELNET_CMD+1	/* 130 */
#define TIMEKERNEL_CMD		TESTEXCEPT_CMD+1
#define TN_CMD			TIMEKERNEL_CMD+1
#define TYPE_CMD		TN_CMD+1
#define UNDEFINE_CMD		TYPE_CMD+1	/* 134 */

#define CMD_OTHER		CMD_HIGHLIMIT	/* 135 */


/*
 * Standard maximum file name length
 */
#define FILE_NAME_LENGTH	62

/*
 * File manipulation constants
 */
typedef short FileType;		/* type of file... one of: */
#define FILETYPE_NUM	5	/* number of filetypes */
#define FILETYPE_EXE	4	/* things that look executable */
#define FILETYPE_TEXT	3	/* things that look like text */
#define FILETYPE_DIR	2	/* Directory */
#define FILETYPE_C	1	/* C source file */
#define FILETYPE_OTHER  0       /* none of the above */

/*
 * icon size constants
 */

#define ICON_X	63	/* heigth of an icon (index origin 0) */
#define ICON_Y	63	/* width of an icon (index origin 0) */

/*
 * Screen Refresh constants - it's expensive, do it only if necessary.
 */
#define REFRESH_ON	1
#define REFRESH_OFF	0
