/*
 ***************************************************************************
 *                              G e t S i z e				   *
 *-------------------------------------------------------------------------*
 *   GetSize returns the size of the screen in device coordinates. (Device *
 *   coordinates are the same as world coordinates in here, since I will   *
 *   map my view to the entire screen, and if there is no "zoom" factor,   *
 *   the VGTS provides no other transformation (except translation, which  *
 *   I will not use) (The other difference is that in device coords, the   *
 *   origin is at the upper left of the screen, with positive x going      *
 *   down, and positive y to the right, while in world coords the origin   *
 *   (if not translated) is at the lower left corner of a view.)           *
 *									   *
 *   I also give a "noinvert" flag if this is a sun-2 with a model100      *
 *   framebuffer, because inverting the letters (reverse video) using      *
 *   the set high order bit trick seems to crash the workstation...        *
 *									   *
 *   Size info stolen from Per's low level graphics routines:		   *
 *      /xV/servers/vgts/draw1.c					   *
 ***************************************************************************
 */

#include <Venviron.h>		/* Message */
#include <Vquerykernel.h>	/* PeriphCR, PRF_FRAME... */

GetSize(x,y,noinvert)
    int *x, *y, *noinvert;
  {
    Message msg;
    PeripheralConfigurationReply *pcr = (PeripheralConfigurationReply *) msg;
    int i;
    unsigned char fbuffer;	/* frame buffer type */

    QueryKernel(0, PERIPHERAL_CONFIG, pcr);

    fbuffer = 0;
    for (i = 0; i < MAX_PERIPHERALS; i++)
      {
	if ((pcr->peripheral[i] == PRF_FRAMEBUFFER_SMI100) ||
	    (pcr->peripheral[i] == PRF_FRAMEBUFFER_SMI120))
	  fbuffer = pcr->peripheral[i];
      }

    switch (fbuffer)
      {
	case PRF_FRAMEBUFFER_SMI100:
	  /* should check for portrait vs landscape - how? */
	  /* also, sun-2  upgrades are all landscape */
	  *x = 1024; /* portrait is 800x1024 instead */
	  *y = 800; 
	  *noinvert = 1;	/* these (in the lab, at least) blow up */
	  break;

	case PRF_FRAMEBUFFER_SMI120:
	  *x = 1152;
	  *y = 900;
	  *noinvert = 0;
	  break;

	default:
	  *x = 1024;	/* use smaller size */
	  *y = 800;
	  *noinvert = 1;	/* why take a chance? */
	  break;
      } /* switch */
  } /* GetSize */
