/*
 * ficons.c: contains the routines for manipulating the function icons
 * 	on the screen.
 */

#include <Vio.h>		/* for stderr */
#include <Vgts.h>		/* SDF_RASTER */
#include "/usr/sun/include/bitmaps.h"		/* for MemoryRaster */
#include "iconstants.h"		/* our global include file */

/* imports */
extern char i_help[], i_listdir[], i_editor[], i_ccompiler[], i_execute[];
extern char i_printer[], i_logout[], i_trash[], i_punt[];


/* data that is global, but used locally within this "module" */
static char *FiconList[] = {	/* list of icon's to put up */
	i_help,
	i_listdir,
	i_editor,
	i_ccompiler,
	i_execute,
	i_printer,
	i_logout,
	i_trash,
	i_punt,
	};

/*
 ***************************************************************************
 *                            A d d I c o n				   *
 *-------------------------------------------------------------------------*
 *   Add in the function icons on the screen.  They are placed vertically  *
 *   in the provided bounded box. 					   *
 ***************************************************************************
 */

AddIcon(sdf, xmin, xmax, ymin, ymax)
	short sdf;		/* sdf we are writing to (already open) */
	int xmin, xmax, ymin, ymax;
  {

    int i;		/* index into iconList */
    int j;		/* y coordinate of icon */


    for (i = 0, j = ymax-5-80;
         i < (1+ICON_HIGHLIMIT-ICON_LOWLIMIT); i++, j-=80)
	if (!AddItem(sdf, ICON_LOWLIMIT+i, xmin+18,xmin+18+ICON_X,
		j, j+ICON_Y, MemoryRaster, SDF_RASTER, FiconList[i]))
	  {
	    fprintf(stderr, "AddItem of function icon %d failed.\n\r",
			ICON_LOWLIMIT+i);
	    Quit();
	  }
  } /* AddIcon */

/*
 ***************************************************************************
 *                        I c o n H i t					   *
 *-------------------------------------------------------------------------*
 *   Field a hit on one of the function icons.				   *
 ***************************************************************************
 */

IconHit(iconNo, fileName, fileType, sdf, mainSymbol, vgt)
    short iconNo;
    char fileName[];
    FileType fileType;
    short sdf, mainSymbol, vgt; 
  {
    short x1,x2,y1,y2;

    switch (iconNo)
      {
	case HELP_ICON:
	  printf("Help icon \n\r");
	  break;
	case LISTDIR_ICON:
	  printf("Listdir icon \n\r");
	  break;
	case EDITOR_ICON:
           printf("Editor icon \n\r");
	   break;
	case CCOMPILER_ICON:
	  printf("C Compiler icon \n\r");
	  break;
	case EXECUTE_ICON:
	  printf("Execute icon \n\r");
	  break;
	case PRINTER_ICON:
	  printf("Printer icon \n\r");
	  break;
	case LOGOUT_ICON:
	  printf("Logout icon \n\r");
	  break;
	case TRASH_ICON:
	  printf("Trash icon \n\r");
	  break;
	case PUNT_ICON:
	  printf("Punt icon \n\r");
	  break;
      }

    /* highlight selected item (since this @#$% thing takes so long) */
    EditSymbol(sdf,mainSymbol);
    InquireItem(sdf,iconNo,&x1,&x2,&y1,&y2,0,0,0);
    /* for explanation of following hack, see FileHit (files.c) */
    x1++; y1++; x2--; y2--;
    DeleteItem(sdf,iconNo);
    AddItem(sdf, iconNo, x1, x2, y1, y2, MemoryRaster|InverseRaster,
		SDF_RASTER, FiconList[iconNo-ICON_LOWLIMIT]);
    EndSymbol(sdf,mainSymbol,vgt);

    DialogDriver(iconNo, fileName, fileType); /* execute function */

    /* bring back icon to normal... */
    EditSymbol(sdf,mainSymbol);
    DeleteItem(sdf,iconNo);
    AddItem(sdf, iconNo, x1, x2, y1, y2, MemoryRaster,
		SDF_RASTER, FiconList[iconNo-ICON_LOWLIMIT]);
    EndSymbol(sdf,mainSymbol,vgt);
}
