/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* 'Other Command' Pad        		*************************************/
/* Routine to implement the dialog box for the 'other command' icon.        */
/* The routine uses a pad as a menu to prompt the user for the command line */
/* to be executed.  It then prepares the command for execution.		    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* Other command length, pad size, max number of cmd arguments */
#define COMMAND_LENGTH	82
#define	OCXPADSIZE	10
#define	OCYPADSIZE	COMMAND_LENGTH+15
#define	MAXARGS		10
static char	BLANKCOMMAND[COMMAND_LENGTH] =
 "                                                                                ";      /* 80 */

/* External routine */
extern File	*OpenPad();

/* Procedures to handle the dialog box */
extern int	Execute(), Quit();
int		CommandOk(), CmdCancel(), ReadCmd();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads 		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	Command[COMMAND_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2];

/* Table for options on the editing menu */
static Field	CmdMenu[] =
   {{  1,  1, -1, NULL,          NULL,         "Command:  <other>"       },
    {  1, 20, -1, NULL, NULL, "( Execute a special command )"		 },
    {  2,  1, -1, NULL,          NULL,         "-----------------"       },
    {  4,  2, 21, VAL OnOff1,    ReadCmd,      " [%s] Command desired "  },
    {  5,  1, -1, VAL Command,   NULL,         "        ==> %ls"         },
    {  8,  2, 12, VAL MarkNo,    CmdCancel,    " [%s] Cancel "           },
    {  8, 18, 12, VAL MarkGo,	 CommandOk,    " [%s] OK     "           },
    LASTFIELD };


/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/

/* Procedure to execute the command on option 'OK' */
CommandOk(f)
   Field *f;
   {
      char *args[MAXARGS];

      done = 1;

      /* Check for error -- no command specified */
      if (( OnOff1[0] != 'X' ) || ( Command[0] == '\0' ))
	  {
	  strcpy( Command, "*** Error: No command specified ***" );
          done = 0;
	  }

/* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
	  cmdstatus = OKDOK;
	  MarkGo[0] = 'X';
	  DisplayFields( CmdMenu, 999, editPad );
	  SelectPad( ReadPad );
	  Close( editPad );
	  ParseLine( Command, args, MAXARGS );
	  Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
CmdCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
	ScreenRefresh = REFRESH_OFF;
   }


/* Procedure to prompt the user for the command to execute */
ReadCmd(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      DisplayFields( CmdMenu, 999, editPad );
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CmdMenu[4], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Other                                            */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select and  */
/* type the command desired.  The user can continue to select  	   */
/* and change the filename for as long as needed.           	   */
/*    When the "OK" option is chosen, the selected command is      */
/* executed. If the "Cancel" option is selected, the command is    */
/* cancelled.						           */
/*******************************************************************/

Do_Other()
   {
    /* Initialization */
    done = 0;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    OnOff1[0] = ' ';		/* OFF: Read command */
    strcpy( Command, BLANKCOMMAND );

    /* Create the edit menu pad */
    editPad = OpenPad( "Other Command Pad", OCXPADSIZE, OCYPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( CmdMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( CmdMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
