/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: define                      *************************************/
/* Routines to implement the dialog box for the 'define'  V-System command. */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		DefineOk(), DeCancel();
int		ReadName(), ReadContName();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code 		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	NameName[FILE_NAME_LENGTH];
static char	ContName[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2];

/* Table for options on the editing menu */
Field	DefineMenu[] =
   {{  1,  1, -1, NULL,          NULL,       "Command:  define"  },
    {  1, 20, -1, NULL, NULL, "( Define a local name for a context )" },
    {  2,  1, -1, NULL,          NULL,       "----------------"  },
    {  3,  1, -1, NULL,          NULL,       "Arguments:"        },
    {  4,  2, 14, VAL OnOff1,    ReadName,     " [%s] Name:    " },
    {  4, 16, -1, VAL NameName,  NULL,         " %s "            },
    {  5,  2, 14, VAL OnOff2,    ReadContName, " [%s] Context: " },
    {  5, 16, -1, VAL ContName,  NULL,         " %s "            },
    {  8,  1, 12, VAL MarkNo,    DeCancel,     " [%s] Cancel "   },
    {  8, 18, 12, VAL MarkGo,	 DefineOk,     " [%s] OK     "   },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
DefineOk(f)
   Field *f;
   {
      char *args[4];

      done = 1;

      /* Set up the argument array */
      args[0] = "define";
      args[1] = NameName;
      args[2] = ContName;
      args[3] = '\0';

      /* Check for error -- no name/context specified */
      if (( OnOff1[0] != 'X' ) || ( NameName[0] == '\0' ))
	  {
	  strcpy( NameName, "*** Error: No name specified ***");
          done = 0;
	  }
      if (( OnOff2[0] != 'X' ) || ( ContName[0] == '\0' ))
	  {
	  strcpy( ContName, "*** Error: No context specified ***");
	  done = 0;
	  }

      /* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
	  cmdstatus = OKDOK;
	  MarkGo[0] = 'X';
	  DisplayFields( DefineMenu, 999, editPad );
	  SelectPad( ReadPad );
	  Close( editPad );
          Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
DeCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
   }


/* Procedure to prompt the user for the name to define.  */
ReadName(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      DisplayFields( DefineMenu, 999, editPad );
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &DefineMenu[5], 0, editPad, inputPad );
      GetTTY();
   }


/* Procedure to prompt the user for the name of the context.   */
ReadContName(f)
   Field *f;
   {
      OnOff2[0] = 'X';
      DisplayFields( DefineMenu, 999, editPad);
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &DefineMenu[7], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Define                                           */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Define()
{
    /* Initialization */
    done = 0;
    ScreenRefresh = REFRESH_OFF;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    OnOff1[0] = ' ';	/* OFF: Read name         */
    OnOff2[0] = ' ';	/* OFF: Read context name */
    strcpy( NameName, BLANKFILE );
    strcpy( ContName, BLANKFILE );

    /* Create the edit menu pad */
    editPad = OpenPad( "define Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( DefineMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( DefineMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
