/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: cp                          *************************************/
/* Routines to implement the dialog box for the 'cp' V-System command.      */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	 *OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		CpOk(), CpCancel();
int		ReadFromFile(), ReadToFile();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		*/
extern int	ScreenRefresh;		/* Screen update flag		*/
static File	*editPad, *inputPad;	/* Pads implementing dialog box */
static Field	*field;			/* Selected field pointer 	*/
static SystemCode error;		/* System error code		*/

/* Static variables for these routines */
static int	done, cmdstatus;
static char	FromFile[FILE_NAME_LENGTH];
static char	ToFile[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2];

/* Table for options on the editing menu */
static Field	CpMenu[] =
   {{  1,  1, -1, NULL,          NULL,         "Command:  cp"         },
    {  1, 20, -1, NULL, NULL, "( Copy one file to another file )"     },
    {  2,  1, -1, NULL,          NULL,         "------------"         },
    {  3,  1, -1, NULL,          NULL,         "Arguments:"           },
    {  4,  2, 17, VAL OnOff1,    ReadFromFile,   " [%s] <From File> " },
    {  4, 19, -1, VAL FromFile,  NULL,           "==> %s "            },
    {  5,  2, 17, VAL OnOff2,    ReadToFile,     " [%s] <To File>   " },
    {  5, 19, -1, VAL ToFile,    NULL,           "==> %s "            },
    {  8,  1, 12, VAL MarkNo,    CpCancel,     " [%s] Cancel "        },
    {  8, 18, 12, VAL MarkGo,	 CpOk,         " [%s] OK     "        },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
CpOk(f)
   Field *f;
   {
      char *args[4];
      int  numargs;

      done = 1;

      /* Set up the argument array */
      numargs = 3;
      args[0] = "cp";
      args[1] = FromFile;
      args[2] = ToFile;
      args[3] = '\0';

      /* Check for error -- No filename specified */
      if (( OnOff1[0] != 'X' ) || ( FromFile[0] == '\0' ))
	  {
	  strcpy( FromFile, "*** Error: No 'from file' specified ***");
          done = 0;
	  }
      if (( OnOff2[0] != 'X' ) || ( ToFile[0] == '\0' ))
	  {
	  strcpy( ToFile, "*** Error: No 'to file' specified ***");
	  done = 0;
	  }

      /* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
	  cmdstatus = OKDOK;
	  MarkGo[0] = 'X';
	  DisplayFields( CpMenu, 999, editPad );
	  SelectPad( ReadPad );
	  Close( editPad );
          Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
CpCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
	ScreenRefresh = REFRESH_OFF;
   }


/* Procedure to prompt the user for the file to copy */
ReadFromFile(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      DisplayFields( CpMenu, 999, editPad );
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CpMenu[5], 0, editPad, inputPad );
      GetTTY();
   }


/* Procedure to prompt the user for the file to copy to */
ReadToFile(f)
   Field *f;
   {
      OnOff2[0] = 'X';
      DisplayFields( CpMenu, 999, editPad);
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CpMenu[7], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Cp                                               */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Cp( FileName )
char FileName[];
{
    /* Initialization */
    done = 0;
    ScreenRefresh = REFRESH_ON;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    if ( FileName[0] != '\0' )
	{
	  OnOff1[0] = 'X';		/* ON:  Read 'from file' */
	  strcpy( FromFile, FileName );
	}
    else
	{	  
	  OnOff1[0] = ' ';  		/* OFF: Read 'from file' */
	  strcpy( FromFile, BLANKFILE );
	}
    OnOff2[0] = ' ';			/* OFF: Read 'to file'   */
    strcpy( ToFile, BLANKFILE );

    /* Create the edit menu pad */
    editPad = OpenPad( "cp Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( CpMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( CpMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
