/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: copydir                     *************************************/
/* Routines to implement the dialog box for the 'copydir' V-System command. */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		CopydirOk(), CopCancel();
int		ReadFrom(), ReadTo();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag 		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	FromDir[FILE_NAME_LENGTH];
static char	ToDir[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2];

/* Table for options on the editing menu */
static Field	CopydirMenu[] =
   {{  1,  1, -1, NULL,          NULL,       "Command:  copydir"   },
    {  1, 20, -1, NULL, NULL, "( Copy one directory subtree to another )" },
    {  2,  1, -1, NULL,          NULL,       "-----------------"   },
    {  3,  1, -1, NULL,          NULL,       "Arguments:"          },
    {  4,  2, 16, VAL OnOff1,    ReadFrom,     " [%s] <From Dir> " },
    {  4, 17, -1, VAL FromDir,   NULL,         "==> %s "           },
    {  5,  2, 16, VAL OnOff2,    ReadTo,       " [%s] <To Dir>   " },
    {  5, 17, -1, VAL ToDir,     NULL,         "==> %s "           },
    {  8,  1, 12, VAL MarkNo,    CopCancel,    " [%s] Cancel "     },
    {  8, 18, 12, VAL MarkGo,	 CopydirOk,    " [%s] OK     "     },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
CopydirOk(f)
   Field *f;
   {
      char *args[4];

      done = 1;

      /* Set up the argument array */
      args[0] = "copydir";
      args[1] = FromDir;
      args[2] = ToDir;
      args[3] = '\0';

      /* Ceck for error -- no directory specified */
      if (( OnOff1[0] != 'X' ) || ( FromDir[0] == '\0' ))
	  {
	  strcpy( FromDir, "*** Error: No 'from dir' specified ***");
          done = 0;
	  }
      if (( OnOff2[0] != 'X' ) || ( ToDir[0] == '\0' ))
	  {
	  strcpy( ToDir, "*** Error: No 'to dir' specified ***");
	  done = 0;
	  }

      /* If no error, close the pad and execute the command */
      if ( done == 1 )
	{
          cmdstatus = OKDOK;
          MarkGo[0] = 'X';
          DisplayFields( CopydirMenu, 999, editPad );
	  SelectPad( ReadPad );
	  Close( editPad );
          Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
CopCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
	ScreenRefresh = REFRESH_OFF;
   }


/* Procedure to prompt the user for the directory to copy */
ReadFrom(f)
   Field *f;   
   {
      OnOff1[0] = 'X';
      DisplayFields( CopydirMenu, 999, editPad );
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CopydirMenu[5], 0, editPad, inputPad );
      GetTTY();
   }


/* Procedure to prompt the user for the directory to copy to */
ReadTo(f)
   Field *f;
   {
      OnOff2[0] = 'X';
      DisplayFields( CopydirMenu, 999, editPad);
      ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
      EditField( &CopydirMenu[7], 0, editPad, inputPad );
      GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_Copydir                                          */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Copydir( FileName )
char FileName[];
{
    /* Initialization */
    done = 0;
    ScreenRefresh = REFRESH_ON;
    MarkGo[0] = ' ';
    MarkNo[0] = ' ';
    if( FileName[0] != '\0' )
	{
	  OnOff1[0] = 'X';
	  strcpy( FromDir, FileName );
	}
    else
	{
	  OnOff1[0] = ' ';
	  strcpy( FromDir, BLANKFILE );
	}
    OnOff2[0] = ' ';		/* OFF: Read 'to dir'    */
    strcpy( ToDir, BLANKFILE );

    /* Create the edit menu pad */
    editPad = OpenPad( "copydir Command Menu", XPADSIZE, YPADSIZE, &error );
    if ( editPad == NULL )
	{
	fprintf( stderr, "Error in opening the edit menu. System code = %d\n",
                                                                       error );
	Quit();
	}

    /* Select the edit menu pad, open it for input,  */
    /* and display the field information.            */
    SelectPad( editPad );
    inputPad = OpenFile( FileServer(editPad), FileId(editPad), FREAD, &error );
    if (inputPad == NULL)
       {
       fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                 error );
       Quit();
       }
    putc( 'L' & 31, editPad );    /* clear the pad */


    /* Select operations until "OK" or "CANCEL" is selected */
    while ( done != 1 )
	{

   	/* Display the current field information */
        DisplayFields( CopydirMenu, 999, editPad );
	Flush( editPad );

	/* Select an operation to perform */
	field = GetField( CopydirMenu, 999, 0, editPad );

	/* Call the procedure to perform the operation */
	if (field) (*(field->proc)) (field);

        }

}
