/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: cc68                        *************************************/
/* Routines to implement the dialog box for the 'cc68' V-System command.    */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.		                    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		CCOk(), CCCancel();
int		Option1(), Option2(), Option3();
int		ReadOut(), ReadPath(), ReadLibr(), ReadCFile();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Update screen flag		    */
static File	*editPad, *inputPad;	/* Pads to implement the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	CompFile[FILE_NAME_LENGTH];
static char	OutFile[FILE_NAME_LENGTH];
static char	PathName[FILE_NAME_LENGTH];
static char 	LibrName[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2], OnOff3[2];
static char	OnOff4[2], OnOff5[2], OnOff6[2], OnOff7[2];

/* Table for options on the editing menu */
static Field	CCMenu[] =
   {{  1,  1, -1, NULL,          NULL,   "Command:  cc68" },
    {  1, 20, -1, NULL, NULL, "( Compile a C program ) "  },
    {  2,  1, -1, NULL,          NULL,   "--------------" },
    {  3,  1, -1, NULL,          NULL,   "Options:"       },
    {  4,  2, 10, VAL OnOff1,    Option1,  " [%s] -vxV "  },
    {  4, 20, -1, NULL, NULL, "( xV system option )"      },
    {  5,  2, 10, VAL OnOff2,    Option2,  " [%s] -c   "  },
    {  5, 20, -1, NULL, NULL, "( compile only )"          },
    {  6,  2, 10, VAL OnOff3,    Option3,  " [%s] -r   "  },
    {  6, 20, -1, NULL, NULL, "( executable .r file )"    },
    {  7,  2, 10, VAL OnOff4,    ReadPath, " [%s] -I   "  },
    {  7, 12, -1, VAL PathName,  NULL,     "<pathname>    ==> %s" },
    {  8,  2, 10, VAL OnOff5,    ReadLibr, " [%s] -l   "  },
    {  8, 12, -1, VAL LibrName,  NULL,     "<library>     ==> %s" },
    {  9,  2, 10, VAL OnOff6,    ReadOut,  " [%s] -o   "  },
    {  9, 12, -1, VAL OutFile,   NULL,     "<output file> ==> %s" },
    { 11,  2, 15, VAL OnOff7,	 ReadCFile," [%s] Filename: " },
    { 11, 17, -1, VAL CompFile,  NULL,   "%s"		   },
    { 13,  1, 12, VAL MarkNo,    CCCancel, " [%s] Cancel " },
    { 13, 18, 12, VAL MarkGo,	 CCOk,     " [%s] OK     " },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
CCOk(f)
   Field *f;
   {
      char *args[10];
      int  numargs;
      char path[FILE_NAME_LENGTH+2];
      char libr[FILE_NAME_LENGTH+2];

      done = 1;

      /* Set up argument array */
      args[0] = "cc68";
      numargs = 1;
      if ( OnOff1[0] == 'X' )   args[numargs++] = "-vxV";
      if ( OnOff2[0] == 'X' )   args[numargs++] = "-c";
      if ( OnOff3[0] == 'X' )   args[numargs++] = "-r";
      if (( OnOff4[0] == 'X' ) && ( PathName[0] != '\0' ))
         {
	    strcpy( path, "-I" );
	    strcat( path, PathName );
	    args[numargs++] = path;
	 }
      if (( OnOff5[0] == 'X' ) && ( LibrName[0] != '\0' ))
         {
	    strcpy( libr, "-l" );
 	    strcat( libr, LibrName );
	    args[numargs++] = libr;
  	 }
      if (( OnOff6[0] == 'X' ) && ( OutFile[0] != '\0' ))
	{
	    args[numargs++] = "-o";
     	    args[numargs++] = OutFile;
	}

      args[numargs++] = CompFile;
      args[numargs] = '\0';

      /* Check for error -- no filename specified */
      if (( OnOff7[0] != 'X' ) || ( CompFile[0] == '\0' ))
	{
	  done = 0;
	  OnOff7[0] = ' ';
	  strcpy( CompFile, "*** Error: No filename specified ***" );
	}

      /* if no error, close the pad and execute the command */
      if ( done == 1 )
	{
	   cmdstatus = OKDOK;
	   MarkGo[0] = 'X';
	   DisplayFields( CCMenu, 999, editPad );
	   SelectPad( ReadPad );
	   Close( editPad );
	   Execute( args );
	}
   }


/* Procedure to cancel the command on option 'Cancel' */
CCCancel(f)
   Field *f;
   {
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
	ScreenRefresh = REFRESH_OFF;
   }


/* Procedure to set the '-vxV' option */
Option1(f)
   Field *f;   
   {
      if ( OnOff1[0] == ' ')  OnOff1[0] = 'X';
      else                    OnOff1[0] = ' ';
   }

/* Procedure to set the '-c' option */
Option2(f)
   Field *f;   
   {
      if ( OnOff2[0] == ' ')  OnOff2[0] = 'X';
      else                    OnOff2[0] = ' ';
   }

/* Procedure to set the '-r' option */
Option3(f)
   Field *f;   
   {
      if ( OnOff3[0] == ' ')  OnOff3[0] = 'X';
      else                    OnOff3[0] = ' ';
   }

/* Procedure to set the '-I' option, and read pathname */
ReadPath(f)
   Field *f;   
   {
      if ( OnOff4[0] == ' ')
	{
	  OnOff4[0] = 'X';

          /* Read the Pathname to search */
          DisplayFields( CCMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &CCMenu[11], 0, editPad, inputPad );
          GetTTY();
 	}
      else
	{
          OnOff4[0] = ' ';
	  strcpy( PathName, BLANKFILE );
	}
    }

/* Procedure to set the '-l' option, and read library name */
ReadLibr(f)
   Field *f;   
   {
      if ( OnOff5[0] == ' ')
	{
	  OnOff5[0] = 'X';

          /* Read the name of the library to search */
          DisplayFields( CCMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &CCMenu[13], 0, editPad, inputPad );
          GetTTY();
    	}
      else
        {
	  OnOff5[0] = ' ';
	  strcpy( LibrName, BLANKFILE );
	}
    }

/* Procedure to set the '-o' option, and read output file name */
ReadOut(f)
   Field *f;   
   {
      if ( OnOff6[0] == ' ')
	{
	  OnOff6[0] = 'X';

          /* Read the name of the output file */
          DisplayFields( CCMenu, 999, editPad);
          ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
          EditField( &CCMenu[15], 0, editPad, inputPad );
          GetTTY();
    	}
      else
        {
	  OnOff6[0] = ' ';
	  strcpy( OutFile, BLANKFILE );
	}
    }


/* Procedure to read the file to compile */
ReadCFile(f)
   Field *f;
   {
	OnOff7[0] = 'X';
        DisplayFields( CCMenu, 999, editPad);
        ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
        EditField( &CCMenu[17], 0, editPad, inputPad );
        GetTTY();
   }


/*******************************************************************/
/* PROCEDURE:  Do_CC68                                             */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_CC68( FileName )
    char FileName[];
    {
	/* Initialization */
	done = 0;
	ScreenRefresh = REFRESH_ON;
	MarkGo[0] = ' ';
	MarkNo[0] = ' ';
	OnOff1[0] = 'X';	/* ON:  -vxV option */
	OnOff2[0] = ' ';	/* OFF: -c   option */
	OnOff3[0] = 'X';	/* ON:  -r   option */
	OnOff4[0] = ' ';	/* OFF: -I   option */
	OnOff5[0] = ' ';	/* OFF: -l   option */
	OnOff6[0] = ' ';	/* OFF: -o   option */
	if ( FileName[0] != '\0' )
	    {
		OnOff7[0] = 'X';	/* ON:  filename given */
		strcpy( CompFile, FileName );
	    }
	else
	    {
		OnOff7[0] = ' ';	/* OFF: Read filename  */
		strcpy( CompFile, BLANKFILE );
	    }
	strcpy( OutFile, BLANKFILE );
	strcpy( PathName, BLANKFILE );
	strcpy( LibrName, BLANKFILE );

        /* Create the edit menu pad */
        editPad = OpenPad( "cc68 Command Menu", XPADSIZE, YPADSIZE, &error );
        if ( editPad == NULL )
            {
            fprintf( stderr, "Error in opening edit menu. System code = %d\n",
                                                                       error );
            Quit();
            }

        /* Select the edit menu pad, open it for input,  */
        /* and display the field information.            */
        SelectPad( editPad );
        inputPad = OpenFile( FileServer(editPad),FileId(editPad),FREAD,&error);
        if ( inputPad == NULL )
           {
           fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                     error );
           Quit();
           }
        putc( 'L' & 31, editPad );    /* clear the pad */


        /* Select operations until "OK" or "CANCEL" is selected */
        while ( done != 1 )
            {

            /* Display the current field information */
            DisplayFields( CCMenu, 999, editPad );
            Flush( editPad );

            /* Select an operation to perform */
            field = GetField( CCMenu, 999, 0, editPad );

            /* Call the procedure to perform the operation */
            if (field) (*(field->proc)) (field);

            }

    }
