/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************/
/* Command: biopsy                      *************************************/
/* Routines to implement the dialog box for the 'biopsy' V-System command.  */
/* The main procedure uses a pad as a menu to prompt the user for options.  */
/* It then prepares the command for execution.				    */
/****************************************************************************/

#include <Vgts.h>
#include <fields.h>
#include <Vio.h>

/* Iconic interface constants */
#include "iconstants.h"
#include "dialogext.h"

/* External routine */
extern File	*OpenPad();

/* Procedures to handle command options */
extern int	Execute(), Quit();
int		BiopsyOk(), BiCancel();
int		Opt1(), ReadPid(), ReadTeamFile();

/* Variables for the dialog box */
extern File	*ReadPad, *WritePad;	/* Command output pads		    */
extern int	ScreenRefresh;		/* Screen update flag		    */
static File	*editPad, *inputPad;	/* Pads implementing the dialog box */
static Field	*field;			/* Selected field pointer	    */
static SystemCode error;		/* System error code		    */

/* Static variables for these routines */
static int	done, cmdstatus;
static char	Pid[PID_LENGTH];
static char	TeamFile[FILE_NAME_LENGTH];
static char	MarkGo[2], MarkNo[2];
static char	OnOff1[2], OnOff2[2], OnOff3[2];

/* Table for options on the editing menu */
static Field	BiopsyMenu[] =
   {{  1,  1, -1, NULL,          NULL,      "Command:  biopsy"       },
    {  1, 20, -1, NULL, NULL,"( Print info about processes on workstation )"},
    {  2,  1, -1, NULL,          NULL,      "----------------"       },
    {  3,  1, -1, NULL,          NULL,      "Options:"               },
    {  4,  2,  8, VAL OnOff1,    Opt1,         " [%s] -l "           },
    {  4, 20, -1, NULL, NULL, "( include filename from which team loaded )"},
    {  5,  2,  8, VAL OnOff2,    ReadPid,      " [%s] -t "           },
    {  5, 10, -1, VAL Pid,	 NULL,         "<pid>       ==> %s"  },
    {  6,  2,  8, VAL OnOff3,    ReadTeamFile, " [%s] -t "           },
    {  6, 10, -1, VAL TeamFile,  NULL,         "<team file> ==> %s"  },
    {  9,  1, 12, VAL MarkNo,    BiCancel,  " [%s] Cancel "  	     },
    {  9, 18, 12, VAL MarkGo,	 BiopsyOk,  " [%s] OK     "  	     },
    LASTFIELD };

/*******************************************************/
/* Procedures for handling the various command options */
/*******************************************************/


/* Procedure to execute the command on option 'OK' */
BiopsyOk(f)
   Field *f;
   {
      char *args[7];
      int  numargs;

      done = 1;
      cmdstatus = OKDOK;
      MarkGo[0] = 'X';
      DisplayFields( BiopsyMenu, 999, editPad );

      /* Set up argument array */
      args[0] = "biopsy";
      numargs = 1;
      if ( OnOff1[0] == 'X' )   args[numargs++] = "-l";
      if (( OnOff2[0] == 'X' ) && ( Pid[0] != '\0' ))
         {
	    args[numargs++] = "-t";
	    args[numargs++] = Pid;
	 }
      if (( OnOff3[0] == 'X' ) && ( TeamFile[0] != '\0' ))
         {
	    args[numargs++] = "-t";
	    args[numargs++] = TeamFile;
  	 }
      args[numargs] = '\0';

      /* Close the pad and execute the command */
      SelectPad( ReadPad );
      Close( editPad );
      Execute( args );
   }


/* Procedure to cancel the command on option 'Cancel' */
BiCancel(f)
   Field *f;
   {	
	done = 1;
	cmdstatus = CANCEL;
	SelectPad( ReadPad );
	Close( editPad );
   }

	
/* Procedure to set the '-l' option */
Opt1(f)
   Field *f;   
   {
      if ( OnOff1[0] == ' ')  OnOff1[0] = 'X';
      else                    OnOff1[0] = ' ';
   }


/* Procedure to set the '-t' option, and read Pid */
ReadPid(f)
   Field *f;   
   {
      if ( OnOff2[0] == ' ')
	  {
	    OnOff2[0] = 'X';

            /* Read the specific ProcessId */
            DisplayFields( BiopsyMenu, 999, editPad);
            ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
            EditField( &BiopsyMenu[7], 0, editPad, inputPad );
            GetTTY();
    	  }
      else
	  {
            OnOff2[0] = ' ';
	    strcpy( Pid, BLANKPID );
	  }
    }

/* Procedure to set the '-t' option, and read team filename */
ReadTeamFile(f)
   Field *f;   
   {
      if ( OnOff3[0] == ' ')
	  {
	    OnOff3[0] = 'X';

            /* Read the team file name */
            DisplayFields( BiopsyMenu, 999, editPad);
            ModifyPad( inputPad, CR_INPUT+LF_OUTPUT+LINEBUFFER+ECHO );
            EditField( &BiopsyMenu[9], 0, editPad, inputPad );
            GetTTY();
    	  }
      else
	  {
            OnOff3[0] = ' ';
	    strcpy( TeamFile, BLANKFILE );
	  }
    }


/*******************************************************************/
/* PROCEDURE:  Do_Biopsy                                           */
/*    The main procedure creates the edit pad for the dialog box,  */
/* displays it for the user, and waits for the user to select the  */
/* options desired.  The user can continue to select and change    */
/* options for as long as needed.                                  */
/*    When the "OK" option is chosen, the selected command is      */
/* executed.  If the "Cancel" option is selected, the command is   */
/* cancelled.                                                      */
/*******************************************************************/

Do_Biopsy()
    {
	/* Initialization */
	done = 0;
	ScreenRefresh = REFRESH_OFF;
	MarkGo[0] = ' ';
	MarkNo[0] = ' ';
	OnOff1[0] = ' ';	/* OFF: Include team       */
	OnOff2[0] = ' ';	/* OFF: Read Pid           */
	OnOff3[0] = ' ';	/* OFF: Read team filename */
	strcpy( Pid, BLANKFILE );
	strcpy( TeamFile, BLANKFILE );

        /* Create the edit menu pad */
        editPad = OpenPad( "biopsy Command Menu", XPADSIZE,YPADSIZE, &error );
        if ( editPad == NULL )
            {
            fprintf( stderr, "Error in opening edit menu. System code = %d\n",
                                                                      error );
            Quit();
            }

        /* Select the edit menu pad, open it for input,  */
        /* and display the field information.            */
        SelectPad( editPad );
        inputPad = OpenFile(FileServer(editPad),FileId(editPad),FREAD,&error);
        if ( inputPad == NULL )
           {
           fprintf( stderr, "Error in opening inputPad. System code = %d\n",
                                                                     error );
           Quit();
           }
        putc( 'L' & 31, editPad );    /* clear the pad */


        /* Select operations until "OK" or "CANCEL" is selected */
        while ( done != 1 )
            {

	    /* Display the current field information */
	    DisplayFields( BiopsyMenu, 999, editPad );
	    Flush( editPad );

            /* Select an operation to perform */
            field = GetField( BiopsyMenu, 999, 0, editPad );

            /* Call the procedure to perform the operation */
            if (field) (*(field->proc)) (field);

            }

    }
