/****************************************/
/* Bob Neilon				*/
/* Madhavan Srinivasan			*/
/* Matthew Zekauskas			*/
/* June 10, 1985			*/
/* CS 246 - Adv O.S.			*/
/* V-System Iconic User Interface	*/
/****************************************************************************/
/*   This file contains several procedures for implementing the dialog      */
/* boxes for V-System commands.						    */
/****************************************************************************/

#include <Venviron.h>
#include <Vgts.h>
#include <Vio.h>
#include <Vteams.h>
#include <fields.h>
/*#include <stdio.h>*/
#include "iconstants.h"
#include "dialogbox.h"

/* Dialog box procedures in this file. */
int  DialogDriver(), CheckFile(), Execute();

/* External Variables */
extern int	ScreenRefresh;			/* Screen update flag  */
extern File	*ReadPad, *WritePad;		/* Command output pads */


/****************************************************************************/
/* DialogDriver                                                             */
/*    This routine receives a command number and (possibly) a filename and  */
/* filetype, and calls the appropriate function to handle the execution     */
/* of the command (with the filename and filetype as arguments).            */
/****************************************************************************/
DialogDriver( commandNo, FileName, FType )
    int  commandNo;
    char FileName[];
    FileType  FType;
    {
	int okay;

	/* Check for error: bad or no filename specified */
	okay  = 0;
	okay = CheckFile( commandNo, FileName, FType );
	if ( okay == 0 )  return(0);

	/* Call routine to execute the command */
        switch( commandNo )
            {
		/* Icon Commands */

	    case HELP_ICON:	    Do_Help();			    break;
	    case LISTDIR_ICON:	    Do_Listdir( FileName );	    break;
	    case EDITOR_ICON:	    Do_Editor( FileName );	    break;
	    case CCOMPILER_ICON:    Do_CC68( FileName );	    break;
	    case EXECUTE_ICON:	    Do_Execute( FileName, FType );  break;
	    case PRINTER_ICON:	    Do_Boise( FileName );	    break;
	    case LOGOUT_ICON:	    Do_Logout();		    break;
	    case TRASH_ICON:	    Do_Rm( FileName );		    break;
	    case PUNT_ICON:	    Do_Punt();			    break;


		/* Menu Commands */

	    case AMAZE_CMD:		Do_Amaze();		break;
	    case BIOPSY_CMD:		Do_Biopsy();		break;
	    case BITS_CMD:		Do_Bits();		break;
	    case CD_CMD:		Do_Cd( FileName );	break;
	    case CHECKERS_CMD:		Do_Checkers();		break;
	    case COPYDIR_CMD:		Do_Copydir( FileName ); break;
	    case CP_CMD:		Do_Cp( FileName );	break;
	    case DALE_CMD:		Do_Dale();		break;
	    case DATE_CMD:		Do_Date();		break;
/*	    case DEBUG_CMD:		Do_Debug();		break;	*/
/*	    case DEFINE_CMD:		Do_Define();		break;	*/
/*	    case DESTROY_CMD:		Do_Destroy();		break;	*/
/*	    case DOPAR_CMD:		Do_Dopar();		break;	*/
/*	    case DOSEQ_CMD:		Do_Doseq();		break;	*/
	    case DRAW_CMD:		Do_Draw();		break;
/*	    case ECHO_CMD:		Do_Echo();		break;	*/
/*	    case FEXECUTE_CMD:		Do_Fexecute();		break;	*/
/*	    case FSCHECK_CMD:		Do_Fscheck();		break;	*/
/*	    case FTP_CMD:		Do_Ftp();	 	break;	*/
/*	    case INTERNETSERVER_CMD:	Do_InternetServer();	break;	*/
/*	    case IPHOST_CMD:		Do_IpHost();		break;	*/
/*	    case IPTELNET_CMD:		Do_IpTelnet();		break;	*/
/*	    case IPTN_CMD:		Do_IpTn();		break;	*/
/*	    case QUERY_CMD:		Do_Query();		break;	*/
/*	    case SERIAL_CMD:		Do_Serial();		break;	*/
/*	    case SHOW_CMD:		Do_Show();		break;	*/
/*	    case STORAGESTATS_CMD:	Do_StorageStats();	break;	*/
/*	    case STUFFBOOT_CMD:		Do_StuffBoot();		break;	*/
/*	    case TESTEXCEPT_CMD:	Do_TestExcept();	break;	*/
/*	    case TIMEKERNEL_CMD:	Do_TimeKernel();	break;	*/
/*	    case TN_CMD:		Do_Tn();		break;	*/
	    case TYPE_CMD:		Do_Type( FileName );	break;
/*	    case UNDEFINE_CMD:		Do_Undefine();		break;	*/

	    case CMD_OTHER:		Do_Other();		break;

	    default:
		SelectPad( ReadPad );
		fprintf( WritePad, "\n*** Command not yet implemented ***" );
		fprintf( WritePad, " ( use 'OTHER' menu bar item ) ***\n\r" );
		fprintf( WritePad, "\n: " );
		Flush( WritePad );
		ScreenRefresh = REFRESH_OFF;

	    }
    }

/****************************************************************************/
/* Routine to check if a command requiring a filename is to be executed,    */
/* but no filename has been specified. Also check if an illegal type of file*/
/* has been specified.  If so, return error message to user.                */
/****************************************************************************/
CheckFile( commandNo, FileName, FType )
   int  commandNo;
   char  FileName[];
   FileType  FType;
   {
	if (( commandNo == EXECUTE_ICON )	||
	    ( commandNo == TRASH_ICON )		||
	    ( commandNo == TYPE_CMD ))
		{
		 if ( FileName[0] == '\0' )
		   {
		     ScreenRefresh = REFRESH_OFF;
		     SelectPad( ReadPad );
		     fprintf( WritePad, "\n*** Error: no filename specified ***\n\r");
		     fprintf( WritePad, "\n: " );
		     Flush( WritePad );
		     return(0);
		   }
		}
	return(1);
   }


/***************************************************************************/
/* Execute()								   */
/*   Procedure to execute the command given in 'argv' on option 'OK'.  The */
/* routine accepts in array argv the command to execute and its parameters.*/
/* It then creates a pad and executes the command with output directed to  */
/* pad.  Finally, it waits for the command to finish before returning.	   */
/***************************************************************************/
/*
 * Functions and variables pulled in from outside for Execute()
 */
extern  InstanceId FileId();		/* to get parameter for ExecProg() */
extern  File *ReadPad, *WritePad;	/* I/O file descriptors for pad */
extern  ProcessId NameServerPid;	/* Set up by TeamRoot  */

char outName[80];			/* buffer for context name */

/* Execute() */
Execute(argv)
   char *argv[];			/* actual command and arguments */
   {
  	int 	    i;			/* loop index */
	ProcessId   pid;		/* pid for command process */
	Message	    dummymsg;		/* to wait for cmd process to end */

	/* Variables used to set up/pass parameters for ExecProg() */
	int	    status;		/* return code from program executed*/
	ProcessId   teamServer;
	InstanceId  InFile, OutFile;
	RootMessage rtMsg;
	ProcessId   serverpid;
	ContextId   contextid;
	SystemCode  error;

	teamServer = 0;
	InFile = FileId( ReadPad );	/* get instance ids of pad */
	OutFile = FileId( WritePad );

	/* set up root message for the command process */
	rtMsg.stdinserver     = FileServer( ReadPad );
	rtMsg.stdoutserver    = FileServer( WritePad );
	rtMsg.stderrserver    = FileServer( WritePad );
	rtMsg.stdinfile       = InFile;
	rtMsg.stdoutfile      = OutFile;
	rtMsg.stderrfile      = OutFile;

	rtMsg.rootflags       = STDOUT_APPEND + STDERR_APPEND;
	rtMsg.envblock	      = NULL;	/* set later? */ 

	
	SelectPad( ReadPad );		/* bring up the pad to the top */

	/* echo command line */
	fprintf( WritePad, "Executing [" );
	for ( i = 0; argv[i] != '\0'; i++ ) fprintf( WritePad, " %s", argv[i] );
	fprintf( WritePad, " ]\n\r" );
	Flush( WritePad );

	/* Execute the command */
	pid = ExecProgram( argv, NULL, &rtMsg, NULL, &status, &error);

	/* Re - synchronize our idea of what has been written to the pad */
	Resynch(WritePad);
	Resynch(ReadPad);

	/* Flush out whatever the process may have written to the banner */
	SetVgtBanner( WritePad, "" );

	/* indicate that command has terminated */
	fprintf( WritePad, "\n: End command.\n\r: " );
	Flush( WritePad );
   }
