/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"


CheckFileDescriptor( nd, fdnumber )
    ND *nd; unsigned fdnumber;

    /* Check over a file descriptor and return OK ifOK, else ILLEGAL_REQUEST.
     */
  {
    extern FsysConfigEntry FsysConfigTable[];
    extern unsigned	Global_fsys_index;
    extern  unsigned Cfi;
    FileDesc *fd;
    register unsigned block, diskblock, blksinfile, allocbytes;
    unsigned fsystart, fsysend;
    register unsigned    *p, *q;
    char c, crlf;

    fsystart = FsysConfigTable[Global_fsys_index].start;
    fsysend = fsystart + FsysConfigTable[Global_fsys_index].length;
    fd = &(nd->fd);
    fdnumber = fd->FDnumber;

    if( nd->fdlink.FDname[0] == '\0' ) /* Free descriptor. */
      {
	Printf( "Confirm file descriptor %d to be zeroed and freed (y/n)",
					fdnumber );
	Flush(stdout);
	c = getchar();
	crlf = getchar(); /* Get the carriage return, line feed. */
	if( c != 'y' && c != 'Y' )
	   {
	     PutStr("Negative confirmation: operation aborted\n" );
	     return;
	   }
	Zero( nd, sizeof(ND) );
	nd->fd.FDnumber = fdnumber;
	return( OK );
      }
    if( fdnumber == 0 ||
     (Convert_blk((fdnumber-1)/NDS_PER_BLOCK, Nd_file_fd) == INVALID_BLOCK) )
      {
	Printf( "Bad FD number %d outside FD file\n", fdnumber );
	return( ILLEGAL_REQUEST );
      }
    /* Check that the extents are zero beyond the first one. */
    p = &fd->FDpointer0;
    q = &fd->FDlastextent;

    while( (p < q) && (*++p) ) ++p; /* Advance to first zero extent or end. */
    if( p != q ) /* Not at end. */
      {
	while( p < q  )
          {
	    if( *p != 0 )
	      {
		Printf("Non-zero pointer/extent field beyond last used\n" );
		Printf("Please zero all unused pointer/extent fields.\n" );
		return( ILLEGAL_REQUEST );
	      }
	    ++p;
	  }
      }
    blksinfile = Blks_in_fd( fd );
    if( blksinfile < (fd->FDeofblk + (fd->FDeofbyte != 0)) )
      {
	Printf("Eof block %d: byte %d beyond %d blocks in file\n",
	blksinfile, fd->FDeofblk, fd->FDeofbyte );
	return( ILLEGAL_REQUEST );
      }
     /* Check that file blocks are contained in file system. */
    for( block = 0; block < blksinfile; ++block )
      {
	diskblock = Convert_blk( block, fd );
	if( diskblock == INVALID_BLOCK )
	  {
	    Printf("Invalid conversion of block %d in file\n", block );
	    return( ILLEGAL_REQUEST );
	  }
	if( (diskblock < fsystart) || (diskblock >fsysend) )
	   {
	     Printf("Block %d as disk block %d is outside file system %d: %d\n",
		block, diskblock, fsystart, fsysend );
	    return( ILLEGAL_REQUEST );
	  }
       } 
    if( fd->FDnumber == 1 )
      {  /* FD file descriptor */
	if( fd->FDpointer0 != 0 )
	  {
	    Printf("FD file starts at block %d, not 1st block of filsystem %d\n",
		fd->FDpointer0, 0 );
	    return( ILLEGAL_REQUEST );
	  }
	if( !Equal( (nd->fdlink.FDname), "fdfile" ) )
	  {
	     Printf("FD file must be called 'fdfile', not %s\n",
		nd->fdlink.FDname );
	     return( ILLEGAL_REQUEST );
	  }
       }
    if( fdnumber == 2 ) /* Bitmap descriptor */
      {
	if( !Equal( nd->fdlink.FDname, "bitmap" ) )
	  {
	     Printf("Bitmap file must be called 'bitmap', not %s\n",
		nd->fdlink.FDname );
	     return( ILLEGAL_REQUEST );
	  }
	if( nd->fdlink.FDfather != 1 )
	  {
	    Printf("FDfather field must be 1, not %d\n",
		nd->fdlink.FDfather );
	    return( ILLEGAL_REQUEST );
	  }
	allocbytes = FsysConfigTable[Global_fsys_index].length/8 +
			(FsysConfigTable[Global_fsys_index].length % 8 != 0 );
	if( (fd->FDeofblk != (allocbytes/Bytes_block)) ||
	    (fd->FDeofbyte != (allocbytes % Bytes_block)) )
	  {
	    Printf("Bad bitmap EOF: should be blk %d, byte %d\n",
		allocbytes/Bytes_block, allocbytes % Bytes_block );
	    Printf("Fix allocation of blocks to bitmap too!\n" );
	    return( ILLEGAL_REQUEST );
	  }
      }
    return( OK );
  }


Update_checksum( argc )
    int argc;

  /* Check the current ND and update checksum if it passed all
   * test.
   * Use:  c
   */
  {
    extern ND  *Cnd;
    extern  unsigned Cfi;

    if( argc > 1 )
      {
        PutStr( "use: c\n" );
        return;
      }

    if( Cfi == CND_UNDEFINED )
      {
        Dis_curfield();
        return;
      }
    if( CheckFileDescriptor( Cnd, Cnd->fd.FDnumber ) != OK )
      {
	Printf("Please correct file descriptor and check again\n" );
	return;
      }
		
    Checksum( Cnd, TRUE );

    Cfi = CHECKSUM;
    Dis_curfield();
  }
