#include "fscheck.h"


Set_fsys( fsys_index )
  unsigned fsys_index;

  {
    /* Set the global fd and bitmap 'File' and 'FileInstance' pointers
     *   to the corresponding pointers of the file system specified by
     *   the parameter 'fsys_index'.  No setting of pointers has to be done
     *   if 'Ss_device_index' (Ss_device_index is the index of the "current"
     *   file system) equals 'fsys_index'.
     */

    extern FsysConfigEntry FsysConfigTable[];
    extern unsigned        Global_fsys_index;
    extern FileDesc        *Nd_file_fd;
    extern File            *Device, *disk_dev[];
    extern ND              *Cnd;
    extern char            *Buffer, *Device_Buffer[];
    extern unsigned        Bytes_block, Blocks_device, Start_root_file, Cfi;
    
    FDLink                 *ptr;

    if( Global_fsys_index == fsys_index )
      return( TRUE );

    if( FsysConfigTable[fsys_index].name[0] == '\0' )
      return( FALSE );  /* if the name is null then the file system has 
                         *   not been initialized.
                         */
    Device = disk_dev[ FsysConfigTable[fsys_index].drive ];
    Buffer = Device_Buffer[ FsysConfigTable[fsys_index].drive ];
    Bytes_block = Device->blocksize;
    Blocks_device = FsysConfigTable[fsys_index].length;

    Global_fsys_index = fsys_index;  /* reflect the new "current" file system */

  printf("File System Set: number = %d, drive = %d, start = %d, length = %d\n",
            Global_fsys_index,
            FsysConfigTable[Global_fsys_index].drive,
            FsysConfigTable[Global_fsys_index].start,
            FsysConfigTable[Global_fsys_index].length );

    Nd_file_fd->FDpointer0 = Start_root_file;
    Nd_file_fd->FDextent0 = 20;
    Device->block = MAXUNSIGNED; /* invalidate the blocknumber so that a 
                                  *  read will occur.
                                  */
    if( Get_nd(1,&ptr,1) == ND_ALLOCATED )
      {
        Copy( Nd_file_fd, ptr+1, sizeof(FileDesc) );
        Copy( Cnd, ptr, sizeof( ND ) );
	Cfi = 0; 
      }
    else
        printf( "bad file descriptor file\n");

    return( TRUE );

  }