/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"


unsigned Scan_time( time_vec, time_str )
	int *time_vec; char *time_str;
    /* Convert the time specified by the time_str into the system format. */
    /* The string must have the following format: */
    /* year/month/day:hour:minute:second:click */
    /* If is assumed to specify local time and is converted to GMT. */
    /* If trailing fields in the string are omitted, the remaining */
    /* fields are treated as zeroes. */
    /* Return TRUE if the string parses correctly otherwise FALSE */
 {
#ifdef TIME_KLUDGE
    unsigned    n, field, delim, expanded_time[10];
    char  *i;

    Zero( expanded_time, 10*BYTES_PER_WORD );
    field = YEAR;
    delim = '/';
    i = 0;

    while(1)
      {
        expanded_time[field] = n = Convert_num( time_str, &i, 10 );

        switch( field )
          {
            case YEAR:
                if( n < 70 || n > 99 ) break;
                field = MONTH;
		break;
            case MONTH:
                if( n == 0 || n > 12 ) break;
                --expanded_time[MONTH];
                field = DAY;
		break;
            case DAY:
                if( (n < 1) ||
                n > Days_in_month(expanded_time[MONTH],expanded_time[YEAR]) )
                    break;
                --expanded_time[DAY];
                field = HOUR;
                delim = ':';
		break;
            case HOUR:
                if( n > 23 ) break;
                field = MINUTE;
		break;
            case MINUTE:
                if( n > 59 ) break;
                field = SECOND;
		break;
            case SECOND:
                if( n > 59 ) break;
                field = CLICKS;
		break;
            case CLICKS:
                if( n >= CLICKS_PER_SECOND ) break;
                field = DAYLIGHT_SAVING;       /* Invalid field */
		break;
            default: break;
          }
        if( time_str[i] == '\0' )   /* End of time_str */
          {
/*            Convert_to_gmt( time_vec, expanded_time );
            Convert_to_local_time( time_vec, expanded_time );
            if( expanded_time[DAYLIGHT_SAVING] )
                Subtract_double( time_vec, 3600 ); /* Subtract one hour */
  	  *time_vec = 1234;
          return( TRUE );
          }
        if( time_str[i++] != delim ) break;
      }
    return( FALSE );
  }
#else
    *time_vec = 1234;
    return( TRUE );
  }
#endif
