/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

ParseStr( str, argv, delim, oper )
	char *str, *argv[], *delim, *oper;
    /* The string  str  is split into substrings which are */
    /* output through the  argv  vector.  Substrings in  str */
    /* are delimited by characters in the strings  delim and  oper. */
    /* The argument  delim  defaults to the string  " *t", and */
    /* oper  defaults to the null string.  Any character in str */
    /* which appears in oper, but not in delim, will appear as */
    /* a string in  argv.  The number of substrings placed in  argv */
    /* is returned by this function. */
    /* Example: command lines are processed by the call */
    /*   argc = Parse_str( str, argv, " *t", "<>" ); */
  {
    extern char *Concat();
    unsigned    i, j, k, argc;
    register char  *temp, c, cc;

    if( delim == 0 )  delim = " *t";
    if( oper == 0 )  oper = "";

    temp = (char *) malloc( Size(str)+1 );
    for( k = 0; k < Size(str)+1; ++k )
      temp[k] = 0;
    argc = 0;

    for( i=0; c=str[i]; )
      {
        if( Any(c, delim) )  
          {
            ++i;
            continue;
          }
        j = 0;
        if( Any(c, oper) )  
          {
            temp[j++] = c;
            ++i;
          }
        else if( str[i] == '"' )
          {
x:          while( (c=str[++i])  &&  c != '"' )  temp[j++] = c;
            if( c == '\0' )  return( MAXUNSIGNED );
            if( str[++i] == '"' )
              {
                temp[j++] = '"';
                goto x;
              }
          }
        else  while( c = str[i] )
          {
             if( Any(c, delim) )  break;
             if( Any(c, oper) )  break;
             temp[j++] = c;
             ++i;
          }
        temp[j] = '\0';
        
        argv[argc++] = Concat( malloc(j+1), temp, 0, 0);
        
      }
    free( temp );
    return( argc );
  } 
