#include "fscheck.h"


Open_fsys( fsys_index, name, drive, start, length )
  unsigned        fsys_index;
  char            *name;
  unsigned        drive;
  unsigned        start;
  unsigned        length;

  {
    /* Enter information into a file system configuration table entry.
     *   This includes the file system's name, drive on which it resides,
     *   start block, and length.  Also, file access descriptors (fads)
     *   and file instances should be allocated to each file system.
     */

    FsysConfigEntry *fsys;

    if( fsys_index >= MAX_NUM_FSYS )
      {
       printf("Error:  Too many file systems.\n");
       printf("  fsys_index = %d, MAX_NUM_FSYS = %d\n",fsys_index,MAX_NUM_FSYS);
       return( FALSE );
      }

    fsys = &FsysConfigTable[fsys_index];
    fsys->drive = drive;
    fsys->start = start;
    fsys->length = length;

    strcpy( fsys->name, name );

    return( TRUE );
    
  }      



Open_all_fsys()

  {
    extern ND              *Follow_path();
    extern unsigned        Global_fsys_index, Bytes_block, Global_num_fsys;
    extern FsysConfigEntry FsysConfigTable[];
    extern File            *Device, *disk_dev[];
    extern char            *Buffer;
    ND                     *nd;
    SystemCode             r, error;
    FsysConfigEntry        *fstable;
    unsigned               bytes, length, i, j, errorflag = 0;

    printf("Initializing...\n");
    /* Configure a dummy root file system so that we can read the file
     *   system configuration file off of the "/" fsys on the root drive. 
     */
    length = (disk_dev[0])->lastblock;
    if( !Open_fsys( ROOT_FSYS_INDEX, "/", ROOT_DRIVE_NUMBER, 
                                   START_FD_FILE, length ) )
      {
        printf("Error opening bootstrap file system.\n");
        return;
      }

    /* cause the bootstrapping file system to be made the "current" fsys */
    Global_fsys_index = MAXUNSIGNED;   /* invalidate Global_fsys_index */
    if( !Set_fsys( ROOT_FSYS_INDEX ) )
      {
        printf("Error setting the bootstrap file system.\n");
        return;
      }

    if( !(nd = Follow_path( FSTABLE_NAME )) )
      {
        printf("Warning: can't get to %s\n",FSTABLE_NAME);
        return;
      }

    if( nd->fd.FDextent0 < 1 )
      {
        printf("Error: %s must contain at least one block.\n", FSTABLE_NAME);
        return;
      }

    SeekBlock( Device, 
                 nd->fd.FDpointer0 + FsysConfigTable[ROOT_FSYS_INDEX].start,
                 FILE_BEGINNING );    
    bytes = Read( Device, Buffer, Bytes_block );
    if( bytes <= 0 )
      {
        printf("Error reading the file system config table.\n");
        return;
      }

    fstable = (FsysConfigEntry *) Buffer;
    for( Global_num_fsys = 0; fstable[Global_num_fsys].name[0] != '\0'; 
                  Global_num_fsys++ )
      {
        i = Global_num_fsys; 
        if( fstable[i].drive >= MAX_NUM_DRIVES )
          {
            printf("Error: drive number too large.\n");
            printf("   %s %d %d %d\n", fstable[i].name, fstable[i].drive,
                                   fstable[i].start, fstable[i].length);
            errorflag = 1;
            break;
          }
         
        if( disk_dev[ fstable[Global_num_fsys].drive ] == NULL )
          {
      printf("Error: file system %d is invalid.  Drive %d does not exist.\n",
              Global_num_fsys, fstable[Global_num_fsys].drive );
            errorflag = 1;
            break;
          }

        if( fstable[i].start + fstable[i].length > 
               (disk_dev[fstable[i].drive])->lastblock )
          {
            printf("Error: exceeded the drive's last block.  lastblock = %d\n", 
               (disk_dev[fstable[i].drive])->lastblock );
            printf("   %s %d %d %d\n", fstable[i].name, fstable[i].drive,
                                   fstable[i].start, fstable[i].length);
            errorflag = 1;
            break;
          }

        for( j = 0; j < i; j++ )
          {
            if( fstable[i].drive == fstable[j].drive )
              if( (fstable[i].start >= fstable[j].start &&
                     fstable[i].start < fstable[j].start + fstable[j].length) ||
                  (fstable[i].start < fstable[j].start &&
                     fstable[i].start + fstable[i].length > fstable[j].start) )
                {
                  errorflag = 1;
                  printf("Error: the following two file systems overlap.\n");
                  printf("   %s %d %d %d\n", fstable[i].name, fstable[i].drive,
                                         fstable[i].start, fstable[i].length);
                  printf("   %s %d %d %d\n", fstable[j].name, fstable[j].drive,
                                         fstable[j].start, fstable[j].length);
                }
          }

        if( errorflag )
          break;

        if( !Open_fsys( Global_num_fsys, fstable[Global_num_fsys].name, 
                                              fstable[Global_num_fsys].drive,
                                              fstable[Global_num_fsys].start,
                                              fstable[Global_num_fsys].length ))
          {
           printf("Error opening file system: Global_num_fsys = %d\n",
                     Global_num_fsys );
            return;
          }

      } /* end initializing the file systems */

    if( errorflag )
      {
        printf("Should initialize the file systems.\n");
        return;
      }

    /* cause the "real" root file system to be made the "current" fsys */
    Global_fsys_index = MAXUNSIGNED;  /* invalidate Global_fsys_index */
    if( !Set_fsys( ROOT_FSYS_INDEX ) )
      {
        printf("Error setting the real root file system.\n");
        return;
      }

    printf("After initialization the file systems are:\n");
    for( i = 0; FsysConfigTable[i].name[0] != '\0'; i++ )
        printf("%s:%d:%d:%d\n",FsysConfigTable[i].name, 
                               FsysConfigTable[i].drive,
                               FsysConfigTable[i].start,
                               FsysConfigTable[i].length );
    printf("\n");
    if( i != Global_num_fsys )
      printf("Error booting file systems: i != Global_num_fsys\n");
 
  }

