/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

Modify_current_field( argc, argv )
  unsigned argc;
  char **argv;
  /* Modify the value of the current field */
  {
    extern ND         *Cnd;
    extern unsigned   Cfi, *Field_address();
    unsigned          num, clicks;
    register unsigned *address, valid_num;
    unsigned          time;
    register char     *str;

    if( argc != 2 )
      {
        PutStr( "use: = <number>\n     = <string>\n" );
        return;
      }

    if( Cfi == CND_UNDEFINED)
      {
        PutStr( "current nd undefined\n" );
        return;
      }

    if( (!Cfi) || (Cfi>LAST_FIELD) )
      {
        Printf( "current field out of range\n" );
        return;
      }

    address = Field_address( Cfi, Cnd );
    valid_num = Conv_num( str=argv[1], &num );

    switch( Cfi )
      {
        case NAME:
            if( Size(str) > BYTES_NAME )
                PutStr( "name too long\n" );
            else
                Concat( address, str, 0, 0 );
	    break;
        case DEVICE:
            if( Graft_node(Cnd) )
                if( valid_num )
                    PutStr( "illegal device name\n" );
                else if( Size(str) > BYTES_DEVICE_NAME )
                    PutStr( "device name too long\n" );
                else
                    Concat( address, str, 0, 0 );
            else
                goto number;
	    break;

        case PERMS:
            if( valid_num )  
                *address = num;
            else
                PutStr( "bad permissions specification\n" );
	    break;
        case TIME:
            if( *argv[1] == 't' )
              *address = GetTime( &clicks );
            else
              {
                PutStr("To update timestamp use: =t\n" );
                return;
              }
	    break;
        default:
number:     if( valid_num )
                *address = num;
            else
                PutStr( "field value must be a number\n" );
      }

    Dis_curfield();
  }
