/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

Io_server( fd )
	 FileDesc *fd;
  {
    SystemCode  reply;
    unsigned    finished;
    Message	msg;
    register    IoRequest *req = (IoRequest *) msg;
    register	IoReply *replymsg = (IoReply *) msg;
    ProcessId id;

    finished = FALSE;

    while( (id = Receive( req )) && !finished )
      {
        printf("Io_server:  %s\n",ErrorString(req->requestcode));
        switch( req->requestcode )
          {
            case QUERY_INSTANCE:
                reply = Query( req, fd );
		break;
            case READ_INSTANCE:
            case WRITE_INSTANCE:
                reply = Read_write( req, fd );
		break;

            case RELEASE_INSTANCE:
                reply = OK;
                finished = TRUE;
		break;

            default:
                reply = ILLEGAL_REQUEST;
		break;
          }
        replymsg->replycode = reply;
        Reply( req, id );
      }
  }

Query( reply, fd )
	QueryInstanceReply *reply; FileDesc *fd;
  {
    extern File *Device;
    extern unsigned Bytes_block;

    reply->fileserver       = GetPid( 0, ANY_PID );
    reply->filetype         = READABLE | WRITEABLE | FIXED_LENGTH;
    reply->blocksize   = Bytes_block;
    reply->filelastblock   = fd->FDeofblk;
    reply->filelastbytes   = fd->FDeofbyte;

    return( OK );
  }

Read_write( req, fd ) IoRequest *req; FileDesc *fd;
  {
    unsigned    block, count, r;

    block = req->blocknumber;
    count = req->bytecount;
    req->bytecount = 0;
    r = OK;

    if( block>fd->FDeofblk ) return( END_OF_FILE );

    if( block==fd->FDeofblk && count > fd->FDeofbyte )
      {
        count = fd->FDeofbyte;
        r = END_OF_FILE;
      }
    if( (block=Convert_blk(block,fd)) == INVALID_BLOCK )
        return( BAD_STATE );

    SeekBlock( Device, block, FILE_BEGINNING );

    req->bytecount = (req->requestcode==WRITE_INSTANCE)
                        ? Write( Device, req->bufferptr, count )
                        : Read( Device, req->bufferptr, count );
    if( req->bytecount != count ) r = FileException( Device );

    return( r );
  }
