/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

Initialize_fsys_table( argc )
  unsigned argc;

  {
    /* Make a file system table. */

    extern ND             *Follow_path();
    extern unsigned       Bytes_block, Global_fsys_index;
    extern File           *Device, *disk_dev[];
    extern char           *Buffer;
    ND                    *nd;
    FsysConfigEntry       *fstable;
    unsigned              bytes, num_fsys, i, j, errorflag = 0;
    char                  crlf;

    if( argc > 1 )
      {
        PutStr( "use: i\n" );
        return;
      }

    if( Global_fsys_index != ROOT_FSYS_INDEX )
      if( !Set_fsys( ROOT_FSYS_INDEX ) )
        {
          printf("Initialize_fsys_table: error returned from Set_fsys\n");
          return;
         }
        
    if( !(nd = Follow_path( FSTABLE_NAME )) )
      {
        printf("Error: must first create a node %s\n",FSTABLE_NAME);
        return;
      }

    SeekBlock( Device, 
                 nd->fd.FDpointer0 + FsysConfigTable[ROOT_FSYS_INDEX].start,
                 FILE_BEGINNING );
   
    if( nd->fd.FDextent0 < 1 )
      {
        printf("Error: %s must contain at least one block.\n", FSTABLE_NAME);
        return;
      }

    fstable = (FsysConfigEntry *) Buffer;

    printf("How many file systems are there? ");
    scanf("%d", &num_fsys);

    if( num_fsys > MAX_NUM_FSYS )
      {
        printf("Error: Too many file systems\n");
        printf("  Maximum number allowable = %d\n", MAX_NUM_FSYS );
        return;
      }

    /* first effectively erase the fstable */
    for( i = 0; i < MAX_NUM_FSYS; i++ )
      fstable[i].name[0] = '\0';

    printf("  Enter the name, drive, starting block, and length of each\n");
    printf("file system on a separate line.\n");
    
    for( i = 0; i < num_fsys; i++ )
      {
        putchar('>');
        scanf("%s %d %d %d", fstable[i].name, &(fstable[i].drive),
                             &(fstable[i].start), &(fstable[i].length) );
        crlf = getchar();
        if( fstable[i].drive >= MAX_NUM_DRIVES )
          {
            printf("Error: bad drive number.\n");
            errorflag = 1;
            break;
          }
 
        if( fstable[i].start < START_FD_FILE )
          {        
           printf("Error: starting block number must be >= %d\n",START_FD_FILE);
            errorflag = 1;
            break;
          }
 
        if( fstable[i].start + fstable[i].length > 
               (disk_dev[fstable[i].drive])->lastblock )
          {
            printf("Error: exceeded the drive's last block.  lastblock = %d\n", 
               (disk_dev[fstable[i].drive])->lastblock );
            errorflag = 1;
            break;
          }
         
        for( j = 0; j < i; j++ )
          {
            if( fstable[i].drive == fstable[j].drive )
              if( (fstable[i].start >= fstable[j].start &&
                     fstable[i].start < fstable[j].start + fstable[j].length) ||
                  (fstable[i].start < fstable[j].start &&
                     fstable[i].start + fstable[i].length > fstable[j].start) )
                {
                  errorflag = 1;
                  printf("Error: the following two file systems overlap.\n");
                  printf("   %s %d %d %d\n", fstable[i].name, fstable[i].drive,
                                         fstable[i].start, fstable[i].length);
                  printf("   %s %d %d %d\n", fstable[j].name, fstable[j].drive,
                                         fstable[j].start, fstable[j].length);
                }
          }
        if( errorflag )
          break;
      }

    if( errorflag )
      {
        printf("Try again.\n");
        return;
      }

    /* write the buffer to the file */

    bytes = Write( Device, Buffer, Bytes_block );

    if( bytes < Bytes_block )
      {
        printf("Error writing to %s.\n", FSTABLE_NAME);
        return;
      }

    Open_all_fsys();  /* now configure the program to the new file systems */

  }
