/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"

Check_tree_structure( argc )
	unsigned argc;
  /* Check the consistency of the tree structure */
  /* of the file system */
  {
    extern FileDesc  *Nd_file_fd;
    extern  unsigned   Bytes_block; /*(needed for NDS_PER_BLOCK) */
    register unsigned    s, num, i;
    char *bit_vec;
    ND        *nd;

    if( argc > 1 )
      {
        PutStr( "use: t\n" );
        return;
      }

    s = Blks_in_fd(Nd_file_fd) * NDS_PER_BLOCK / BITS_PER_BYTE;

    bit_vec = (char *) malloc( s );
    for( i = 0; i < s; ++i)
      bit_vec[i] = 0;

    for( num=1; (s=Get_nd(num,&nd,1))!=ND_EOF; ++num )
        if( s != ND_ALLOCATED )
            Set_bit_vec( num, bit_vec );
        else if( nd->fdlink.FDson != GRAFTED_FILESYS )
            Check_children( num, nd->fdlink.FDson, bit_vec );

    Check_bit_vec( num, bit_vec );

    free( bit_vec );
  }
