/*
 * V-System Storage System Check Program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */

#include "fscheck.h"


Check_nd( num, nd )
	register unsigned num; FDLink *nd;
  {
    unsigned    status;
    register FileDesc      *fd;

    fd = (FileDesc *) (nd + 1);

    if( nd->FDname[0] == '\0' )
      {
        fd->FDnumber = num;
        return( ND_FREE );
      }

    if( Checksum(nd,0) )
        status = ND_ALLOCATED;
    else
      {
        Printf( "nd# %d: bad checksum\n", num );
        status = ND_ERR;
      }

    if( fd->FDnumber != num )
      {
        Printf( "nd# %d: bad FDnumber field (has the value %d)\n",
                    num, fd->FDnumber );
        fd->FDnumber = num;
      }

    if( (fd->FDcontextid & 0x0000ffff) != num ||
        (fd->FDcontextid & 0x00ff0000) != 0 ||
        (fd->FDcontextid & 0xff000000) == 0 )
      {
        Printf( "nd# %d: bad FDcontext field (has the value 0x%08x)\n",
                    num, fd->FDcontextid );
        fd->FDcontextid = ((GetTime(0)|1)<<24) | num;
      }

    return( status );
  }
