/*
 * freemem.c
 *
 * Dynamically updated free memory indicator for V workstations
 *
 * HISTORY:
 * 4 February 1986	Jeffrey Mogul	Stanford
 *	- Created.
 */

#include <Venviron.h>
#include <stdio.h>
#include <Vgts.h>
#include <Vio.h>
#include <Vquerykernel.h>

#define MN 0
#define MH 10
#define MV 0
#define	WIDTH 70
#define	BARWIDTH 15
#define	BARSEP 5
#define	BARLEFT 25

short   Mvgt,
        Msdf;
extern  ProcessId Kernel_Process_Pid;
char    Name[256];
int	AutoPlaced = 0;


main(argc, argv)
int argc;
char **argv;
{
	if ((argc > 1) && (argv[1][0] == '-'))
		AutoPlaced++;

	memwatch();
}

watch() {
	Message msg;

	while (1)
	    Receive(msg);
}


memwatch() {
	unsigned    total,
	            freem,
	            freemem();
	float   mem[75];
	float   memlevel;
	float   oldlevel;
	int     i;
	unsigned long	nowfree;
	ProcessId watchpid;
	int     watch();
	SystemCode QueryWorkstationConfig();
	short   font = DefineFont("Helvetica7", NULL);
	short   titlefont = DefineFont("Clarity12", NULL);
	char    MemString[100];

	/* catch break */
	watchpid = Create(100, watch, 512);
	Ready(watchpid, 0);
	SetBreakProcess(stdin, watchpid);

    	if (QueryWorkstationConfig("name", Name, 80) != OK)
            strcpy(Name, "Status");
	strcat(Name,
		"                                                         ");
	freemem(&total);
	memlevel = oldlevel = 0;

	font = DefineFont("Helvetica7", NULL);

	Msdf = CreateSDF();
	DefineSymbol(Msdf, MN + 1, "Memory");

	AddItem(Msdf, MN + 2, MH + 10, MH + WIDTH, MV + 15, MV + 16,
		0, SDF_HORIZONTAL_LINE, NULL);
	AddItem(Msdf, MN + 3, MH + 10, MH + WIDTH, MV + 65, MV + 66,
		0, SDF_HORIZONTAL_LINE, NULL);
	AddItem(Msdf, MN + 4, MH + 10, MH + WIDTH, MV + 115, MV + 116,
		0, SDF_HORIZONTAL_LINE, NULL);
	AddItem(Msdf, MN + 5, MH + 3, MH + 15, MV + 12, MV + 17,
		font, SDF_TEXT, "0%");
	AddItem(Msdf, MN + 6, MH - 3, MH + 10, MV + 62, MV + 67,
		font, SDF_TEXT, "50%");
	AddItem(Msdf, MN + 7, MH - 8, MH + 5, MV + 112, MV + 117,
		font, SDF_TEXT, "100%");
	AddItem(Msdf, MN + 14, MH + 5, MH + WIDTH, MV + 125, MV + 130,
		titlefont, SDF_TEXT, "Free");
	AddItem(Msdf, MN + 13, MH + 5, MH + WIDTH, MV + 5, MV + 5,
		font, SDF_TEXT, Name);

	AddItem(Msdf, MN + 20, MH + BARLEFT, MH + BARLEFT + BARWIDTH, MV + 15,
		(int) (MV + 15 + ( /* oldlevel */ 0.5 * 100)), GRAY,
		SDF_FILLED_RECTANGLE, NULL);
	AddItem(Msdf, MN + 20 + 1, MH + BARLEFT + BARWIDTH + BARSEP,
		MH + BARLEFT + BARSEP + (BARWIDTH * 2), MV + 15,
		(int) (MV + 15 + ( /* memlevel */ 0.5 * 100)), BLACK,
		SDF_FILLED_RECTANGLE, NULL);

	EndSymbol(Msdf, MN + 1, 0);

	Mvgt = CreateVGT(Msdf, GRAPHICS + ZOOMABLE, MN + 1, "Memory");

	i = frameBuffer();
	if (AutoPlaced == 0)
		DefaultView(Mvgt, WIDTH + 20, 165, 0, 0, 0, 0, 0, 0);
	else switch (i) {
	    case PRF_FRAMEBUFFER_SUN1: 
		CreateView((int) Mvgt,
			(short) 900,			/*  sxmin          */
			(short) 5,			/*  symin          */
			(short) 900 + WIDTH + 20,	/*  sxmax          */
			(short) 5 + 160,		/*  symax          */
			(short) 0,			/*  wxmin          */
			(short) 0,			/*  wymin          */
			(char) 0, 0);			/*  zoom, showgrid */
		break;

	    case PRF_FRAMEBUFFER_SUN2: 
		CreateView((int) Mvgt,
			(short) 1025,			/*  sxmin          */
			(short) 5,			/*  symin          */
			(short) 1025 + WIDTH + 20,	/*  sxmax          */
			(short) 5 + 160,		/*  symax          */
			(short) 0,			/*  wxmin          */
			(short) 0,			/*  wymin          */
			(char) 0, 0);			/*  zoom, showgrid */
		break;

	    default: 
		DefaultView(Mvgt, WIDTH + 20, 165, 0, 0, 0, 0, 0, 0);
	}

	memlevel = 0;
	while (1) {
	    oldlevel = memlevel;
	    while (1) {
		if (!ValidPid(watchpid))
		    Quit();
		nowfree = freemem(0);
		memlevel = 1.0 - (nowfree * 1.0) / (total * 1.0);
		if (oldlevel != memlevel)
		    break;
		sleep(1);
		/* printf("mem = %f\n", mem[29] ) ; */
	    }
	    EditSymbol(Msdf, MN + 1);
	    ChangeItem(Msdf, MN + 20,
	    	    MH + BARLEFT, MH + BARLEFT + BARWIDTH, MV + 15,
		    (int) (MV + 15 + (oldlevel * 100)), GRAY,
		    SDF_FILLED_RECTANGLE, NULL);
	    ChangeItem(Msdf, MN + 20 + 1, MH + BARLEFT + BARWIDTH + BARSEP,
		    MH + BARLEFT + BARSEP + (BARWIDTH * 2), MV + 15,
		    (int) (MV + 15 + (memlevel * 100)), BLACK,
		    SDF_FILLED_RECTANGLE, NULL);

	    HowMuch(MemString, nowfree);

	    /* ChangeItem on an SDF_TEXT item cause VGTS to kick the bucket */
	    DeleteItem(Msdf, MN + 14);
	    AddItem(Msdf, MN + 14, MH + 5, MH + WIDTH, MV + 125, MV + 130,
		    titlefont, SDF_TEXT, MemString);

	    EndSymbol(Msdf, MN + 1, Mvgt);
	}
}


Quit() {
	DeleteVGT(Mvgt, 1);
	DeleteSDF(Msdf);
	exit(0);
}


unsigned
            freemem(tot)
int    *tot;
/* 
 *   unsigned freemem(tot)
 *        int *tot ;
 *
 *
 * freemem returns the no of free bytes in workstation.
 *
 * it expexts an integer pointer as argument. If this is nonnull
 * the total amount of memory in system is stored there.
 *
 */

{
	static  Message msg;
	static  ProcessId pid = 0;
	QueryKernelRequest * reqmsg = (QueryKernelRequest *) msg;
	MachineConfigurationReply * machreply =
	    (MachineConfigurationReply *) msg;
	MemoryStatisticsReply * memreply =
	    (MemoryStatisticsReply *) msg;

	if (pid == 0)
	    pid = Creator(0);
	if (tot) {
	    QueryKernel(pid, MACHINE_CONFIG, machreply);
	    *tot = machreply->fastMemory + machreply->slowMemory;
	}

	QueryKernel(pid, MEMORY_STATS, memreply);

	return(memreply->unusedFastMemory + memreply->unusedSlowMemory);
}


frameBuffer() {
	static  Message msg;
	PeripheralConfigurationReply * pmsg
		= (PeripheralConfigurationReply *) msg;
	int     i;

	QueryKernel(GetPid(0, 0), PERIPHERAL_CONFIG, pmsg);
	if (pmsg->replycode != OK)
	    return(0);
	for (i = 0; i < MAX_PERIPHERALS; i++)
	    if ((pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN1) ||
		    (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN2))
		return(pmsg->peripheral[i]);
	return(0);
}

HowMuch(s, b)
char *s;
unsigned int b;
{
	sprintf(s, "%dK free", b/1024);
}
