/* queryexec.c: test the exec server */

#include <Venviron.h>
#include <Vio.h>
#include <Vexec.h>

extern SystemCode QueryExec();

main(argc, argv)
  int argc;
  char *argv[];
  {
    int execid;
    ProcessId execserver;
    SystemCode error;
    ProcessId execpid, programpid;
    short status;

    if (argc < 2) {printf("no argument!\n");  return;}
    execid = atoi(argv[1]);

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (execserver == 0)
      {
	fprintf(stderr,"No exec server!\n");
	return;
      }
    error = QueryExec(execserver, execid, &execpid, &programpid, &status);
    PrintError(error,"query exec ");
    fprintf(stderr,"exec pid %x, program pid %x, status %d\n",
	execpid, programpid, status);
  }

