/*
 * menu.h - dimension definitions for the draw menu layout.
 */

#define MemoryRaster 0x04    
#define InverseRaster 0x80 /* 1 is "white" instead of as normal "black" */

#define NOUNROW 6		/* Rows and columns in nouns menu */
#define NOUNCOL 3		/* NOUNROW*NOUNCOL = NOUNS_TOTAL in icons.h */
#define STIPROW 7		/* Rows and columns in stipple menu */
#define STIPCOL 4
#define NIBROW  4		/* Rows and columns in nib menu */
#define NIBCOL  4
#define CMDROW  3		/* Rows and columns in commands menu */
#define CMDCOL  4

#define GAP0 2			/* gap between similar objects*/
#define GAP1 10			/* distance from edge of menu */
#define GAP2 6			/* Gap from top of message to bottom of verb */
#define GAP3 16			/* Gap from right of verb to left of others */
#define GAP4 10			/* Gap from bottom of nouns to top of nibs */
#define GAP5 10			/* Gap from bottom of nibs to top of cmds */


	/* Message rectangle in world coordinates */
#define MesgXMin	GAP1    
#define MesgYMin	GAP1
#define MesgYMax	(MesgYMin + 41)

	/* Verbs */
#define VerbXMin	MesgXMin
#define VerbXMax	(VerbXMin + 63)
#define VerbYMin	(MesgYMax + GAP2)
#define VerbYMax	(VerbYMin + (32+GAP0)*VERBS_TOTAL)

	/* Nouns */
#define NounXMin	(VerbXMax + GAP3)
#define NounXMax	(NounXMin + NOUNROW*33)
#define NounYMin	(VerbYMax - NOUNCOL*33)
#define NounYMax	VerbYMax

#define MesgXMax 	NounXMax

	/* Nibs */
#define NibXMin		NounXMin
#define NibXMax		(NibXMin  + NIBROW*(16+GAP0))
#define NibYMax		(NounYMin - GAP4)
#define NibYMin		(NibYMax  - NIBCOL*(16+GAP0))

	/* Stipples */
#define StipXMax	NounXMax
#define StipXMin	(NounXMax - STIPROW*(16+GAP0))
#define StipYMAX	NibYMax
#define StipYMin	(StipYMax - STIPCOL*(16+GAP0))

        /* Commands */

#define ComdXMin	NounXMin
#define ComdXMax	NounXMax
#define ComdYMax	(NibYMin - GAP5)
#define ComdYMin	(ComdYMax - CMDCOL*(32+GAP0))

	/* Font display */
#define FontXMin	NounXMin
#define FontXMax	NounXMax
#define FontYMin	(VerbYMin + 2)
#define FontYMax	(FontYMin + 32)
#define FontTick1	(FontXMin+(FontXMax-FontXMin)/3)
#define FontTick2	(FontXMax-(FontXMax-FontXMin)/3)

#define Mxmin		  10	/* Screen coordinates of the menu window */
#define Mxmax		(NounXMax + GAP1 + 10)
#define Mymin		  10
#define Mymax		(NounYMax + GAP1 + 30)

/* Page is 8 1/2" by 11" at 72 dots/inch */

#define PAGE_WIDTH	612
#define PAGE_HEIGHT	792

/*
 * The main view is calculated from an 8 1/2*11 page inset on all four sides
 * by 16 pixels so that the printer margin is accounted for. The height also
 * takes the V banner into consideration.
 */
#define MVxmin		Mxmax+20	   /* Main View Left Screen Edge */
#define MVxmax		(MVxmin+PAGE_WIDTH-32)
					   /* Main View Right Screen Edge */
#define MVymin		  10		   /* Main View Top Screen Edge */
#define MVymax		(MVymin+PAGE_HEIGHT-20)
					   /* Main View Bottom Screen Edge */
