/*
 *  inum.c
 *
 *  This is a (silly?) attempt to re-use VGTS item numbers in draw.
 *  All item number assignments must go through these routines.
 *
 *  Gustavo Fernandez, February '86
 */
 
 
/* Includes */
#ifdef UNIX
#include "stdio.h"
#else
#include "Vio.h"
#endif
#include "splines.h"
#include "Vgts.h"
#include "draw.h"
 
 
/* Exports */
extern InitINum();		/* Init item number freelist */
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */
    
/* Local definitions */

#define MAXINUMSTACK 500
static short INumStack[MAXINUMSTACK];
static short HighNum;		/* Highest item number ever given out */
static short LastGiven;		/* Last number given out */
static short NextStack;		/* Next position on stack to be filled */

InitINum()

  {
    HighNum = 0;
    NextStack = 0;
  }

short GetINum()

  {
    if (NextStack == 0) 
	return(LastGiven = ++HighNum);
    else
	return(LastGiven = INumStack[--NextStack]);
  }

short GetSeqINum(number)
  short number;

  {
    LastGiven = HighNum + 1;
    HighNum += number;
    return(LastGiven);
  }

short LastINum()
  {
    return(LastGiven);
  }

short FreeINum(item)
  short item;
  {
    register short i;
    if (Debug&Debug_INum)
      for (i=0;i<NextStack;i++)
	if (INumStack[i]==item) {
	    printf("Draw Error! Duplicate free item number %d\n\r",item);
	    ResetTTY();
	    abort();
        }
    if (NextStack < MAXINUMSTACK)
	INumStack[NextStack++] = item;
    return(item);
  }
        
DebugINum()
  {
    short i;

    printf("INum: HighNum=%d; LastGiven=%d; NextStack=%d\n\r",HighNum,LastGiven,NextStack);
    printf("Free stack:");
    for (i=0;i<NextStack;i++)
	printf("%d ",INumStack[i]);
    printf("\n\r");
  }
 
