/*
 *  drawpress.c
 *
 * This file contains one exported routine, DrawPress(), which generates
 * a press file from the current drawing and sends it to the dover.
 *
 * Gustavo Fernandez, October 23, 1984
 *
 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
# include "vec.h"
# include "press.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern char *GetString();
 
/* Exports */
extern DrawPress();

/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)


/*
 *  This internal routine is a helper process for DrawPress().  This
 *  routine will scan the activelist, and draw each object.
 */
 
ScanDraw( id, xoff,yoff )
	PART *id;
	int xoff,yoff;
  {
    OBJECT *p;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Stop when we run out of data. */
    if (id == NULL)
	return;	
	switch (id->type)
	  {
	    case TextObj:
	        /* Text.  Draw the text string. */
		{ /*decompose the font name into family, size and face*/
		    char rawname[50], *rawptr;
		    char *packname;
		    int size,face;
		    packname=FontData[id->subtype].fontname;
		    for (rawptr=rawname;*packname<'0'||*packname>'9';
			    rawptr++,packname++) *rawptr=(*packname);
		    *rawptr='\0';
		    for (size=0;*packname>='0'&&*packname<='9';packname++)
			size=size*10+*packname-'0';
		    face=ROMAN;
		    for (;*packname!='\0';packname++) {
		        if (*packname=='I') face+=ITALIC;
		        if (*packname=='B') face+=BOLD;	
		    };
		    VecFont(rawname,size,face);
		} 
		VecPosn(DrawToPix(id->xmin+xoff),DrawToPix(id->ymin+yoff));
		VecText(id->data); 
		break;
	    
	    case GroupObj:
	        /* Groups.  Print the group name, and its items. */
		p = ((OBJECT_HEADER *) id->data)->first;
		while (p)
		  {
		    ScanDraw( p->part, p->dx+xoff,p->dy+yoff );
		    p = p->next;
		  }
		break;
	    
	    default:
	        /* Splines.  Print the spline data. */
		sptr = (SPLINE *) id->data;
		if (sptr->filled)
		    mprintf(1,"Warning: Outline substituted for filled object\nin PRESS output.");
		pptr = &(sptr->head);
		VecNib(sptr->nib);
		VecSpline(sptr->numvert,pptr,sptr->order,sptr->closed,
				xoff,yoff);
		break;
	  }
  }

/*
 *  This routine will draw the activelist on a press file
 */
 
DrawPress(fname,pname)
char *fname, *pname; 
  {
    OBJECT *p;
    

    VecInit(fname);
    for ( p = activelist->first; p; p = p->next )
      {
	ScanDraw( p->part,p->dx,p->dy );
      }
    VecFinish("Press file generated by V draw program",0,0,pname);
  }
