/*
 *  commands.c
 *
 *  This file contains the code the deal with the named draw commands
 *  such as load, save, etc. 
 *
 */
 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern char *GetString();
extern char *GetStr2();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern SetCurrentObject();
extern DrawPress();
extern WriteFile();
extern ReadFile();
extern SetCurrentCommand();
extern WritePSM();
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */
 
 
/* Exports */
extern CommandHelp();
extern CommandLoad();
extern CommandSave();
extern CommandPrint();
extern CommandAll();
extern CommandClear();
extern CommandQuit();
extern CommandFont1();
extern CommandFont2();
 
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */
#define IndepFlag TRUE


/*
 *  The help front end
 */
CommandHelp(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  Help();
}

/*
 *  The clear front end
 */
CommandClear(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    OBJECT *p,*q;
    if (cmd != CClear) {
	mprintf(2,"Clear aborted!\n'\r");
	SetCurrentCommand(CNull);
    }
    else if (CurrentCommand!=CClear) {
	if (modified) 
	    mprintf(0,"There are unsaved changes\n\rClick clear again to clear the page and lose them.\n\r\007");
	else
	    mprintf(0,"Are you sure you want to clear?\n\rClick clear again to confirm.\n\r");
	SetCurrentCommand(CClear);
    }
    else {
	Checkpoint();
	SetCurrentObject(NULL,FALSE,FALSE,FALSE);
	p = activelist->first;
	while (p)
	      {
	        q = p->next;
		EraseObject( p, 0 );
		p = q;
	      }
	MajorChange();
	modified = 0;
	SetCurrentCommand(CNull);
	DeleteMessage(0);
    }
}

/*
 *  The Load front end
 */
CommandLoad(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
  ReadFile();
}

/*
 *  The Save front end
 */
CommandSave(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
  WriteFile();
}

/*
 *  The Print front end
 */
CommandPrint(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
    DoPrint();
}
/*
 * These are the pop-up items for the debug menu
 */
static PopUpEntry DebugMenu[] =
  {
    "Debug flags...",		0,
    "All flags off",		1,
    "Monkey",			2,
    "Active list",		3,
    "Item numbers",		4,
    "Vitals",			5,
    "Debugger",			6,
    "Keep journal file",	7,
    NULL,			0,
  };

static PopUpEntry DebugFlagsMenu[] =
  {
    "  Objects      ",	0,
    "  Parts        ",  1,
    "  Symbols      ",  2,
    "  Chechpoint   ",  3,
    "  Groups       ",  4,
    "  Fonts        ",  5,
    "  Find         ",	6,
    "  Input        ",	7,
    "  Events       ",	8,
    "  Item numbers ",	9,
    "  I/O          ",	10,
    "  Point        ",	11,
    "  Messages     ",  12,
    "  Select       ",  13,
    NULL,			0,
  };



/*
 *  The Debug front end
 */
CommandDebug(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    short i,temp;
    int *crowbar;
    if (Monkey && but != 7) return;
    i = GetPopup( DebugMenu );
    if (i < 0) return;

    switch(i) {
	case 0: /* Debug flags */
	    for (i = 0,temp=1;i<DEBUG_ITEMS;i++,temp *= 2)
		if (Debug&temp) {
		    DebugFlagsMenu[i].string[0]='+';
		}
		else {
		    DebugFlagsMenu[i].string[0]='-';
		}
    	    i = GetPopup( DebugFlagsMenu );
    	    if (i < 0) return;
	    Debug ^= 1<<i;
	    printf("Debug mode (%d).\n\r",Debug);
	    break;
	case 1:	/* Debug off */
	    Debug = 0;
	    printf("Exit Debug mode.\n\r");
	    break;
	case 2: /* Monkey */
	    printf("The monkey is a debugging tool which generates random\n\r");
	    printf("events until a step count is reached or the program crashes.\n\r");
/*	    printf("hold down all three mouse buttons in the debug box to regain control.\n\r"); */
	    printf("Enter the number of steps to run, -1 for infinite, 0 to cancel:"); 
	    Monkey = 0;
	    MonkeySteps = atoi(GetStr2("        ",8));
	    temp = MonkeySteps == 0 ? 0 : 1;
	    if (!temp) break;
	    printf("Enter a random number seed:");
	    i = atoi(GetStr2("        ",8));
	    srand(i);
	    Monkey = 1;
	    printf("Monkey turned on.\n\r");
	    break;
	case 3:	/* Active List */
	    printf("CurrentObject = %x; FakeGroup = %s\n\r",CurrentObject,
		FakeGroup?"TRUE":"FALSE");
	    DupCheck++;
	    DebugObjectList( "active list", activelist, 4 );
	    break;
	case 4:	/* Item numbers */
	    DebugINum();
	    break;
	case 5:	/* Vitals */
	    printf("    sdf = %d, menuVgt = %d, mainVgt = %d,\n\r",
		sdf, menuVgt, mainVgt );
	    printf("    menuSymbol = %d, mainSymbol = %d.\n\r",
		menuSymbol, mainSymbol );
	    printf("    activelist = %x, FirstPart = %x, LastPart = %x\n\r",
		activelist, FirstPart, LastPart);
	    printf("    CurrentObject = %x; FakeGroup = %s\n\r",
		CurrentObject, FakeGroup?"TRUE":"FALSE");
	    printf("\n\r");
	    break;
	case 6: /* Abort to debugger */
	    printf("Down we go...\n\r");
	    ResetTTY();
	    crowbar = (int *)1;
	    *crowbar = 0xfade;
	    GetTTY();
	    printf("Welcome back!\n\r");
	    break;
	case 7: /* Keep journal */
	    if (Journal != JournalPlay)
	        SaveJournal = TRUE;
	    if (JournalFOut != NULL)
		fflush(JournalFOut);
	    break;
      }
}

/*
 *  This function will perform the 'quit' command.
 */
CommandQuit(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    
  if (Monkey) return;
    /* Don't exit in the middle of things. */
    if (Journal==JournalPlay) {
	mprintf(2,"Quit disabled during Journal playback");
	SetCurrentCommand(CNull);
	return;
    }
    else if (cmd != CQuit) {
	mprintf(2,"I guess we'll stay around a bit longer.\n\r");
	SetCurrentCommand(CNull);
    }
    else if (CurrentCommand!=CQuit) {
	/* If unsaved changes exist, confirm exit. */
	if (modified)
	    mprintf(0,"**WARNING** There are unsaved changes.\n\r\007Click Quit again to exit draw.\n\r");
	else
	    mprintf(0,"Click Quit again to exit draw.\n\r");
	SetCurrentCommand(CQuit);    
    }
    else {
	/* 
	 * This is the "Normal" quit exit. Delete the journal file unless the
	 * user explicitly asked to keep it. Non-fatal errors will also set
	 * the SaveJournal flag.
 	 */
	if (!SaveJournal && JournalFOut != NULL) {
	    fclose(JournalFOut);
#ifdef UNIX
	    unlink(JOURNALNAME);
#else  UNIX
	    RemoveFile(JOURNALNAME);
#endif
	    JournalFOut = NULL;
	}
    	Quit(0);
    }
}


/*
 * The Range command
 */

static POINT_DATA RangePrompts[] =
  {
    { "Enter one corner of the selection.", 0, 0, 0, },
    { "Enter the opposite corner of the selection.", 0, 0, 0, },
  };
 
CommandRange(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    register short xmin,xmax,ymin,ymax,t;
    
    if (DefPoint(CRange,cmd,x,y,but,2,RangePrompts,0)) {
	xmin = RangePrompts[0].x;
	xmax = RangePrompts[1].x;
	ymin = RangePrompts[0].y;
	ymax = RangePrompts[1].y;
	if (xmin>xmax) {
	    t = xmin; xmin = xmax; xmax = t;
	}
	if (ymin>ymax) {
	    t = ymin; ymin = ymax; ymax = t;
	}
	SelectRange(xmin,xmax,ymin,ymax);
      }
  }

/*
 *  This is the default nib command. 
 */
CommandNib(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    SetCurrentNib(x);
    if (CurrentObject != NULL) {
	Checkpoint();
	AttribObject(CurrentObject,0,x,-2,-1,-1,IndepFlag);
    }
}
/*
 *  This is the default pattern command. 
 */
CommandPattern(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    SetCurrentPat(x);
    if (CurrentObject != NULL) {
	Checkpoint();
	AttribObject(CurrentObject,0,-1,x,-1,-1,IndepFlag);
    }
}
/*
 *  This is the Fonts 1 command. 
 */
CommandFont1(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(1,-1);
}
/*
 *  This is the Font 2 command. 
 */
CommandFont2(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(2,-1);
}
/*
 *  This is the centering command. 
 */
CommandCenter(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(-1,x);
}
