@string(LastEditDate="Fri Aug 30 10:41:53 1985")

@string(ManualTitle="V-System 5.1 Reference Manual")
@string(Authors="Distributed Systems Group")

@LibraryFile(RefManual)
@style(references StdNumeric, FileDate "8 March 1952")
@modify(page, within Chapter, numbered "@#@:-@1", referenced "@#@:-@1") 
@modify(hd0, pagebreak before)
@modify(hd1, pagebreak before, 
	initialize "@set(page=1)@process(pageheadings)")
@equate(np=newpage)

@define(Warning=quotation, indent 0, initialize "@p(Warning:) ")
@define(Note=quotation, indent 0, initialize "@b(Note:) ")

@comment( *** KAL -- 7/27/85
	All the magic with pageheading and footing placement is because
	Scribe is somewhat stupid.  When Scribing a piece of a document
	via "parts" and "roots", commands in the root file will only
	be read up to point where the first text is generated.  Therefore,
	the "part" will end up with the style settings -- including page
	headings and footings -- in effect at the time the first text
	is generated.  In this case, the first text is generated within
	titlepage.mss, which has no headings OR footings; in short,
	totally wrong for what we want to do.  So, here we place the
	@page- commands that we want in effect for the "body" of the
	document, and then we have to play with those settings in/for each
	of the preface, the titlepage, the introduction, etc.  Blech,
	barf, gag, but it works.
    ***)

@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@pagefooting(odd, left="@c[@title(MajorPart)]",
	right="@c[@value(FileDate)]")
@pagefooting(even, left="@c[@value(FileDate)]",
	right="@c[@value(ManualTitle)]")

@include(titlepage)

@comment( Headings and footings were turned off INSIDE titlepage.mss! )

@pageheading(odd, left="@c[@value(SectionTitle)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(SectionTitle)]")
@pagefooting(left="@c[@value(ManualTitle)]",
	right="@c[@value(FileDate)]")
@modify(page, numbered "@i")
@include(preface)

@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@modify(page, numbered "@#@:-@1")
@newpage
@set(page=4)
@string(lastprecontentspage=page)
@comment(style(pagenumber="@1")
@include(intro)

@pageheading()
@pagefooting()
@np
@MajorPart(Commands)
@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@pagefooting(odd, left="@c[@title(MajorPart)]",
	right="@c[@value(FileDate)]")
@pagefooting(even, left="@c[@value(FileDate)]",
	right="@c[@value(ManualTitle)]")

@np
@include(cmds/overview)
@np
@include(cmds/exec)
@np
@Include(cmds/cmds)
@np
@Include(cmds/ved)
@np
@include(cmds/draw)
@comment(include(cmds/siledit)
@np
@Include(cmds/bits)
@comment(include(cmds/telnet)
@np
@include(cmds/build)
@np
@Include(cmds/debug)
@np
@include(cmds/amaze)
@np
@include(cmds/checkers)
@np
@include(cmds/hack)
@np
@include(cmds/fscheck)
@np
@include(cmds/standalone)

@pageheading()
@pagefooting()
@np
@MajorPart(Program Environment)
@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@pagefooting(odd, left="@c[@title(MajorPart)]",
	right="@c[@value(FileDate)]")
@pagefooting(even, right="@c[@value(FileDate)]",
	right="@c[@value(ManualTitle)]")

@np
@Include(libc/overview)
@np
@Include(libc/mechanics)
@np
@Include(libc/config)
@np
@Include(libc/io)
@np
@Include(libc/numeric)
@np
@Include(libc/mem)
@np
@Include(libc/process)
@np
@include(libc/naming)
@np
@include(libc/pgmexec)
@np
@include(libc/execctl)
@np
@include(libc/service)
@np
@include(libc/vgts)
@np
@include(libc/fields)
@np
@include(libc/emt)
@np
@Include(libc/others)

@pageheading()
@pagefooting()
@np
@MajorPart(Servers)
@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@pagefooting(odd, left="@c[@title(MajorPart)]",
	right="@c[@value(FileDate)]")
@pagefooting(even, right="@c[@value(FileDate)]",
	right="@c[@value(ManualTitle)]")

@np
@Include(servers/overview)
@np
@include(servers/ioprotocol)
@np
@include(servers/naming)
@np
@Include(servers/devices)
@np
@Include(servers/exceptions)
@np
@include(servers/pipe)
@np
@Include(servers/internet)
@np
@include(servers/storage)
@np
@Include(servers/unix)
@np
@include(servers/service)
@np
@include(servers/exec)
@np
@include(servers/termagent)
@np
@Include(servers/vgts)
@np
@include(servers/sts)
@np
@include(servers/localname)
@np
@include(servers/team)
@np
@include(servers/mem)

@begin(comment)
@MajorPart(Kernel)
@chapter(Kernel Overview)
@label(Koverview)
@Include(kernel/overview.body)
@include(kernel/operations.mss)
@Include(kernel/exceptions)
@Include(kernel/perform)
@Include(kernel/internals)
@Include(kernel/maintain)
@end(comment)

@modify(page, within appendix, numbered "@#@:-@1", referenced "@#@:-@1")

@pageheading()
@pagefooting()
@np
@MajorPart(Appendices)
@pageheading(odd, left="@c[@title(Section)]",
	right="@c[@value(page)]")
@pageheading(even, left="@c[@value(page)]",
	right="@c[@title(Chapter)]")
@pagefooting(odd, left="@c[@title(MajorPart)]",
	right="@c[@value(FileDate)]")
@pagefooting(even, left="@c[@value(FileDate)]",
	right="@c[@value(ManualTitle)]")

@np
@include(biblio)
@np
@include(libc/style)
@np
@include(install/install)
@np
@include(libc/findex)

@comment[For index, table of contents, etc.:]
@pageheading(odd, left="@c[@value(SectionTitle)]",
	right="@c[@value(page)]", immediate)
@pageheading(even, left="@c[@value(page)]",
	right="@c[@value(sectionTitle)]")
@pagefooting(left="@c[@value(ManualTitle)]",
	right="@c[@value(date)]")
@set(page=0)
@modify(page, numbered "Index-@1")

