#include <Venviron.h>
#include <Vio.h>

/* Main routine for "doseq" - (aka "domake"). */
/* Ross Finlayson - August 1984. */

/* Usage: doseq "dir1 dir2 ..." "cmd"
   Changes to the specified directories and executes cmd in each. */

/* The name of this command. */
#define CmdName "doseq"

/* Possible delimiters of directory names in a string. */
char Delimiters[] = " \t\n\r";

extern char *strsave();

main(argc, argv)
    int argc;
    char *argv[];
  {
    char dirList[500], *cmdString, *dirPtr, *dirEndPtr;
    char *curctx;
    SystemCode err;

    if (argc != 3)
      {
        printf("usage: %s \"dir1 dir2 ...\" \"cmd\"\n", CmdName);
	fflush(stdout);
	return 1;
      }

    /* Remember the current context */
    curctx = strsave(PerProcess->ctxname);

    cmdString = argv[2];

    strcpy(dirList, argv[1]);
    dirEndPtr = dirList;

    /* skip over leading delimiters. */
    while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) != 0) )
	    ++dirEndPtr;

    while (1)
      {
	/* find the directory name, if any. */
	dirPtr = dirEndPtr;
        while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) == 0) )
	        ++dirEndPtr;
	if (*dirEndPtr != NULL)
	    *dirEndPtr++ = NULL;
	     
	/* Change to this directory, and execute the command. */
	if (do_cd(dirPtr) != -1)
	    if (index(cmdString, '*'))
		do_remoteshell(cmdString, NULL); /* kludge! */
	    else
		do_exec(cmdString, NULL);

	/* reset our current context. */
	err = ChangeDirectory(curctx);
	if (err != OK)
	  {
	    fprintf(stderr, "%s: can't change back to parent directory: %s\n",
		CmdName, ErrorString(err));
	    exit(err);
	  }

	/* skip over trailing delimiters. */
	while ( (*dirEndPtr != NULL) && (index(Delimiters, *dirEndPtr) != 0) )
		++dirEndPtr;
	if (*dirEndPtr == NULL)
	    return 0;
      }
  }
