/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Used to be listdir, but has been hacked down to the minimal functionality
 * required to get the job done.
 */

#include <Vioprotocol.h>
#include <Vnaming.h>
#include "Vdirectory.h"

#define MAX_DIR_SIZE 		1024	/* largest we can handle */
#define MAX_REPLIES		256
#define REPLY_DELAY		(1*CLICKS_PER_SEC)
#define MAX_CTX_NAME_LEN	256
#define MAX_FILENAME_LEN	512		/* current max for unix 4.2 */
#define BUILD_NAME		1		/* for print_info */

unsigned long RootStackSize = 20000;

extern int ReadAndPrintDirectory();
extern ProcessId DirectToCurrentContext();

extern CompareDescriptors();

static char *myName;
static ArbitraryDescriptor *DescriptorList[MAX_DIR_SIZE];

int longflag = 0, nosortflag = 0, debug = 0;

/* get_ss: if there were no arguements, get all of the storage servers'
 * names available on the net at the current moment, and then print
 * information about the allocation of all of them.
 */
get_ss( argv )
    char *argv;
  {
    register int num;
    char ctxname[ MAX_CTX_NAME_LEN ];
    ContextPair context;

    /*
     * Process command arguments.
     */

    strcpy( ctxname, argv );
    GetAbsoluteName( ctxname, sizeof( ctxname ), &context );

    num = ReadAndPrintDirectory( argv );
  } /* main */

int ReadAndPrintDirectory( dirName )
    char *dirName;
/*
 * Read the contents of the directory and put all non EmptyDescriptors
 * in the DescriptorList.
 * returns the number of entries or -1 if an error
 */
  {
    register int i;
    register ArbitraryDescriptor *desc;
    register ArbitraryDescriptor **descptr;
    register File *serverFile;
    ProcessId serverPid;
    int hexpid = 0;
    int lastdesc = 0;
    int bannertype = EMPTY_DESCRIPTOR;
    int size, replycount;
    CreateInstanceReply replyArray[MAX_REPLIES];
    register CreateInstanceReply *reply = &replyArray[0];
    register CreateInstanceRequest *request =
    	(CreateInstanceRequest *) &replyArray[0];
    ProcessId replierArray[MAX_REPLIES];
    ProcessId *replier = &replierArray[0];
    SystemCode error;
    /* Send initial request */
    request->requestcode = CREATE_INSTANCE;
    request->filename = dirName;
    request->filenamelen = strlen(dirName);
    request->filenameindex = 0;
    request->filemode = FREAD|FDIRECTORY;
    request->type = 0;
    *replier = NameSend(request);

    if (reply->replycode == MORE_REPLIES)
      {
	char *namespot;

	do
	  {
	    ProcessId *xpid;  CreateInstanceReply *xmsg;  /*debugging*/
	    if (debug) { xpid = replier; xmsg = reply; }

	    /* Collect additional replies */
            while ( (*++replier = GetReply(++reply, REPLY_DELAY)) != 0 ) ;

	    if (debug)
	       for ( ; xmsg <= reply; xpid++, xmsg++ )
		   printf("pid= %x, replycode= %s\n",
		   *xpid, ErrorString(xmsg->replycode));

	    /* Retry request to be sure all were reached */
	    request = (CreateInstanceRequest *) reply;
	    request->requestcode = CREATE_INSTANCE_RETRY;
	    *replier = 0;
	    namespot = (char *) (replier + 1);
	    strcpy(namespot, dirName);
	    request->filename = (char *) replierArray;
	    request->filenameindex = namespot - (char *) replierArray;
	    request->filenamelen = request->filenameindex + strlen(dirName);
	    request->filemode = FREAD|FDIRECTORY;
	    request->type = 0;
	    if (debug) printf("resending...\n");
	    *replier = NameSend(request);
	  }
	while (reply->replycode == MORE_REPLIES);

	if (debug) printf("pid= %x, replycode= %s\n",
			  *replier, ErrorString(reply->replycode));

	reply--; /* point to last valid reply */
      }
    else if (reply->replycode != OK)
      {
	fprintf( stderr, " error opening: %s\n", 
			ErrorString( reply->replycode ) );
        return( -1 );
      }

    replycount = reply - replyArray + 1;
    reply = replyArray;

    for (i=0; i<replycount; i++)
      {
	if (reply->replycode != MORE_REPLIES && reply->replycode != OK)
	  {
	    /* Skip this reply.  (Should not happen if servers consistent.) */
	    reply++;
	    continue;
	  }

	/* Ugh!  OpenFile queries the instance again, but we already
	 *  have a QueryInstanceReply!  Maybe it's time to re-permute
	 *  Open, OpenFile, _Open, and CreateInstance.
	 */
	serverFile = OpenFile(reply->fileserver, reply->fileid,
		FREAD|FDIRECTORY|FRELEASE_ON_CLOSE|FBLOCK_MODE, &error);
	reply++;
       
	if (error != OK)
	  {
	    fprintf(stderr, " error on OpenFile (%x, %x): %s\n",
	    	    reply->fileserver, reply->fileid, ErrorString(error));
	    continue;
	  }

	/* load up the Descriptor list */
	desc = (ArbitraryDescriptor *) malloc(sizeof(ArbitraryDescriptor));
    
	/* Protect ourselves against brain-damaged servers */
	if (serverFile->blocksize > sizeof(ArbitraryDescriptor))
	    size = sizeof(ArbitraryDescriptor);
	else
	    size = serverFile->blocksize;
    
	do 
	  {
	    if ( Read( serverFile, desc, size ) > sizeof(EmptyDescriptor) )
	      {
		if ( desc->e.descriptortype != EMPTY_DESCRIPTOR )
		  {
		    DescriptorList[lastdesc++] = desc;
		    if (lastdesc > MAX_DIR_SIZE)
		      {
			fprintf(stderr,
			        "%s: directory too long to sort\n", myName);
			exit(1);
		      }
		    desc = (ArbitraryDescriptor *) 
			malloc(sizeof(ArbitraryDescriptor));
		  }
		serverFile->block++;
	      }
	    else
	       break;	/* an error has occurred */
	  }
	while ( serverFile->lastexception == OK );
    
    
	if ( (error = serverFile->lastexception) != END_OF_FILE )
	  {
	    fprintf(stderr, "Error reading block #%d from (%x, %x): %s\n",
			serverFile->block, FileServer(serverFile),
			FileId(serverFile), ErrorString( error ) );
	  }
	Close(serverFile);
      }

    if ( ! nosortflag) 
      {
	/* Sort directory */
        qsort(DescriptorList, lastdesc, sizeof(ArbitraryDescriptor *), 
    	    CompareDescriptors);
	if (replycount > 1)
	  {
	    /* Suppress duplicates caused by multi-manager subcontexts
	     *  of the one being listed.
	     */
	   descptr = DescriptorList;
	   for (i=0; i<lastdesc-1; i++)
	     {
		if ( (*descptr)->c.descriptortype == CONTEXT_DESCRIPTOR &&
		     (*(descptr+1))->c.descriptortype == CONTEXT_DESCRIPTOR &&
		     strncmp( (*descptr)->c.name, 
		     	      (*(descptr+1))->c.name, MAX_NAME_LENGTH ) == 0 )
		  {
		    (*descptr)->c.descriptortype = EMPTY_DESCRIPTOR;
		  }
		descptr++;
	     }
	  }
      }

    /* Now print it */
    if( ! longflag )
      {
	int i, len, empty ;
	
	/* first compute no of entries per line */
	empty = 0 ;
	for( i=0; i<lastdesc; i++ )
	  {
	    len = strlen(DescriptorList[i]->f.name);
	    /* Compress out empty descriptors */
	    if (len == 0)
	      {
		empty++;
		free(DescriptorList[i]);
	      }
	    else if (empty != 0)
	      {
	        DescriptorList[i-empty] = DescriptorList[i];
	      }
	  }
	lastdesc -= empty;
	for( i=0; i<lastdesc; i++ )
	  {	/* Only want to print something if it's a V Storage Server, */
		/* but unfortunately both UNIX Storage Servers and V Storage */
		/* Servers have a descriptor type of CONTEXT_DESRIPTOR. */
		/* At least the memservers don't get printed! */
	    if( DescriptorList[i]->e.descriptortype == CONTEXT_DESCRIPTOR )
		print_info( BUILD_NAME, DescriptorList[i]->f.name );
	    free( DescriptorList[i] ) ;
	  }
      }

    return( lastdesc );

  } /* ReadAndPrintDirectory */


/*
 * Compare two descriptors and return <0, 0, or >0 depending on
 *  whether the first is less than, equal to, or greater than
 *  the second in sorted order.
 */
CompareDescriptors(d1, d2)
    ArbitraryDescriptor **d1, **d2;
  {
    register ArbitraryDescriptor *desc1 = *d1;
    register ArbitraryDescriptor *desc2 = *d2;
    register int diff;

/*
    if ((diff = desc1->e.descriptortype - desc2->e.descriptortype) != 0)
        return (diff);
*/

    switch (desc1->e.descriptortype)
      {
	case EMPTY_DESCRIPTOR:
	    return (0);		/* all are equal */

	case FILE_DESCRIPTOR:
	case UNIXFILE_DESCRIPTOR:
	case DEVICE_DESCRIPTOR:
	case TEAM_DESCRIPTOR:
	case INTERNET_DESCRIPTOR:
	case CONTEXT_DESCRIPTOR:
	default: /* best guess */
	    return (strncmp(desc1->f.name, desc2->f.name, MAX_NAME_LENGTH));

	case VGT_DESCRIPTOR:
	    return (desc1->v.fileid - desc2->v.fileid);

	case QUEUE_DESCRIPTOR:
	    return (desc1->q.rank - desc2->q.rank);

        case HOST_DESCRIPTOR:
	    return (strncmp(desc1->h.hostName, desc2->h.hostName,
	    		MaxObjectNameLength));
      }
  }
