#include "diff.h"
/*
 * diff - driver and subroutines
 */


main(argc, argv)
	int argc;
	char **argv;
{
	register char *argp;

	ifdef1 = "FILE1"; ifdef2 = "FILE2";
	status = 2;
	diffargv = argv;
	argc--, argv++;
	while (argc > 2 && argv[0][0] == '-') {
		argp = &argv[0][1];
		argv++, argc--;
		while (*argp) switch(*argp++) {

#ifdef notdef
		case 'I':
			opt = D_IFDEF;
			wantelses = 0;
			continue;
		case 'E':
			opt = D_IFDEF;
			wantelses = 1;
			continue;
		case '1':
			opt = D_IFDEF;
			ifdef1 = argp;
			*--argp = 0;
			continue;
#endif
		case 'D':
			/* -Dfoo = -E -1 -2foo */
			wantelses = 1;
			ifdef1 = "";
			/* fall through */
#ifdef notdef
		case '2':
#endif
			opt = D_IFDEF;
			ifdef2 = argp;
			*--argp = 0;
			continue;
		case 'e':
			opt = D_EDIT;
			continue;
		case 'f':
			opt = D_REVERSE;
			continue;
                case 'n':
                        opt = D_NREVERSE;
                        continue;
		case 'b':
			bflag = 1;
			continue;
		case 'c':
			opt = D_CONTEXT;
			if (isdigit(*argp)) {
				context = atoi(argp);
				while (isdigit(*argp))
					argp++;
				if (*argp) {
					fprintf(stderr,
					    "diff: -c: bad count\n");
					done();
				}
				argp = "";
			} else
				context = 3;
			continue;
		case 'h':
			fprintf(stderr, "diff: hflag not supported (yet)\n") ;
			exit(1) ;
			hflag++;
			continue;
		case 'S':
			if (*argp == 0) {
				fprintf(stderr, "diff: use -Sstart\n");
				done();
			}
			start = argp;
			*--argp = 0;		/* don't pass it on */
			continue;
		case 'r':
			rflag++;
			continue;
		case 's':
			sflag++;
			continue;
		case 'l':
			lflag++;
			continue;
		default:
			fprintf(stderr, "diff: -%s: unknown option\n",
			    --argp);
			done();
		}
	}
	if (argc != 2) {
		fprintf(stderr, "diff: two filename arguments required\n");
		done();
	}
	file1 = argv[0];
	file2 = argv[1];
	if (hflag && opt) {
		fprintf(stderr,
		    "diff: -h doesn't support -e, -f, -n, -c, or -I\n");
		done();
	}
	if (!strcmp(file1, "-"))
		stb1.st_mode = S_IFREG;
	else if (mystat(file1, &stb1) < 0) {
		fprintf(stderr, "diff: ");
		perror(file1);
		done();
	}
	if (!strcmp(file2, "-"))
		stb2.st_mode = S_IFREG;
	else if (mystat(file2, &stb2) < 0) {
		fprintf(stderr, "diff: ");
		perror(file2);
		done();
	}
	if ((stb1.st_mode & S_IFMT) == S_IFDIR &&
	    (stb2.st_mode & S_IFMT) == S_IFDIR) {
		diffdir(argv);
	} else
		diffreg();
	done();
}

char *
savestr(cp)
	register char *cp;
{
	register char *dp = malloc(strlen(cp)+1);

	if (dp == 0) {
		fprintf(stderr, "diff: ran out of memory\n");
		done();
	}
	strcpy(dp, cp);
	return (dp);
}

min(a,b)
	int a,b;
{

	return (a < b ? a : b);
}

max(a,b)
	int a,b;
{

	return (a > b ? a : b);
}

done()
{
	if (tempfile)
		unlink(tempfile);
	exit(status);
}

char *
talloc(n)
{
	register char *p;
	p = malloc((unsigned)n);
	if(p!=NULL)
		return(p);
	noroom();
}

char *
ralloc(p,n)	/*compacting reallocation */
char *p;
{
	register char *q;
	char *realloc();
	free(p);
	free(dummy);
	dummy = malloc(1);
	q = realloc(p, (unsigned)n);
	if(q==NULL)
		noroom();
	return(q);
}

noroom()
{
	fprintf(stderr, "diff: files too big, try -h\n");
	done();
}

mystat(fname,st )
    char *fname ;
    struct stat *st ;
  {
/*
 * Do a NREAD_DESCRIPTOR on "fname" and fill in fileds of st
 * returns -1 on error.
 */
    ArbitraryDescriptor desc;
    extern SystemCode NReadDescriptor() ;

    if ( NReadDescriptor(fname, &desc) != OK )
	return( -1 );

    switch (desc.f.descriptortype) {
      case (FILE_DESCRIPTOR):
        st->st_size = desc.f.size ;
	st->st_mtime = desc.f.timestamp ;
	st->st_mode = 0 ;
	if (desc.f.perms & SS_DIR)
	    st->st_mode |= S_IFDIR ;
	else
	    st->st_mode |= S_IFREG ;
	return(0) ;
      case (UNIXFILE_DESCRIPTOR) :
        st->st_size = desc.u.st_size ;
	st->st_mtime = desc.u.st_mtime ;
	st->st_mode = desc.u.st_mode ;
        return (0) ;
      /* nothing else supported at this time */
      default:
	return(-1) ;
    }
  }

perror(f)
    char *f ;
  {
    static char fname[100] ;
    
    fprintf(stderr, "Error on file %s\n", f) ;
  }
