/*
 * Determine whether buf looks like the start of a VAX a.out file; returns
 *   1 if it does, 0 otherwise.  See asciifile.c for comments about byte-
 *   swapping etc.
 */

#include "../vax/b.out.h"	/* This is really a.out.h, but with fields */
				/* etc. renamed so that they almost agree  */
				/* with the 68000 b.out.h		   */

#ifdef DEBUG
static debug_print(x)
    int x;
  {
    if (x)
	puts("--- VAX magic # ---");
    return x;
  }
#else
#define debug_print(x) (x)
#endif

aoutfile(buf, cnt)
    char *buf;
    int  cnt;
  {
    struct bhdr hdr;

    if (cnt < sizeof hdr)
	return 0;
#ifdef LITTLE_ENDIAN
    return debug_print(!N_BADMAG(*(struct bhdr *)buf));
#else
    ByteSwapLongCopy(buf, (char *)&hdr, sizeof hdr);
    return debug_print(!N_BADMAG(hdr));
#endif LITTLE_ENDIAN
  }
