/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Program to destroy a team.
 * Currently only one team may be specified at a time.
 * Teams may be specified by process-id or by unique suffix of their filename.
 * Specifying a non-unique filename yields an error message and nothing is
 * destroyed.  Process-ids may be specified without their high-order 16 bits
 * if so desired.  E.g. 0x9790047 can be specified as just 0x47.
 * Process-ids must be specified in hex with a  0x  preceding the number.
 *
 * Marvin Theimer, 6/83.
 *	First written.
 * Marvin Theimer, 12/8/83
 *	Added capability to specify teams by string name.
 */

#include <Vio.h>
#include <Vteams.h>
#include <Vdirectory.h>

#define FALSE 0
#define TRUE 1

#define PID_MASK 0xffff

extern SystemCode DestroyProcess(), ForceException();

ProcessId PidOfTeamFileName();

main(argc,argv)
  int argc;
  char **argv;
  {
    ProcessId pid;
    SystemCode err;
    int interruptFlag = 0;

    if( argc < 2 )
      {
	fprintf( stderr, "Usage: destroy [-i] <process-id or name>" );
	exit( 1 );
      }

    argc--;
    
    for(; argc; argc--, argv++)
      {
        if (argv[1][0] == '-')
	  {
	    switch (argv[1][1])
	      {
	        case 'i':
		    interruptFlag = 1;
		    break;
		default:
		    fprintf(stderr, "destroy: Unknown flag -%c\n", argv[1][1]);
		    exit(1);
	      }
	    continue;
	  }
        if ((argv[1][0] == '0') && (argv[1][1] == 'x'))
          {
            argv[1] += 2;
	    if (sscanf( argv[1], "%x", &pid ) != 1)
	      {
	        fprintf(stderr, "Invalid process id specified: %s\n\n", argv[1]);
	        continue;
	      }
	    if (pid <= PID_MASK)
	      {
	        pid |= GetPid(ACTIVE_PROCESS, LOCAL_PID) & (~PID_MASK);
				    /* Allow user to leave host part of pid 
				       blank. */
	      }
          }
        else
          {
	    pid = PidOfTeamFileName(argv[1]);
	    if (pid == -1) continue;
          }
	/* try to destroy as an individual process */
	if ( (err = (interruptFlag ? ForceException : DestroyProcess)( pid )) != OK )
	    fprintf(stderr,  "destroy 0x%x: %s\n", pid, ErrorString(err) );
      }
  } /* main */


/*
 * PidOfTeamFileName:
 * Returns the pid corresponding to the team filename specified by s.
 * Exits the program if s does not correspond to an actual team or specifies
 * a nonunique team filename.
 * s is matched against SUFFIXES of team filenames returned from the 
 * team server.
 */

ProcessId PidOfTeamFileName(s)
    char *s;
  {
    File *serverFile;
    SystemCode error;
    ProcessId pid;
    ArbitraryDescriptor desc;
    int count = 0;

    /* Compare s to the suffix of the filename of each team in the system. */
    serverFile = Open("[team/local]", FREAD|FDIRECTORY|FBLOCK_MODE, &error);
    if (error != OK)
      {
	fprintf(stderr, "ERROR while trying to open the team servers directory: %s\n",
		ErrorString(error));
	exit(1);
      }
    do
      {
	if ( Read(serverFile, &desc, serverFile->blocksize) >=
		sizeof(EmptyDescriptor) &&
	     desc.t.descriptortype == TEAM_DESCRIPTOR )
	  {
	    if (MatchesSuffix(desc.t.fileName, s))
	      {
		count++;
		pid = desc.t.rootPid;
	      }
	  }
	serverFile->block++;
      }
    while (serverFile->lastexception == OK);
    if (serverFile->lastexception != END_OF_FILE)
      {
	fprintf(stderr, "ERROR while reading the team server's directory: %s\n",
		ErrorString(serverFile->lastexception));
	exit(1);
      }
    Close(serverFile);
    if (count == 1)
      {
	return(pid);
      }
    else if (count == 0)
      {
	fprintf(stderr, "destroy: %s not found.\n", s);
	return(-1);
      }
    else
      {
	fprintf(stderr, "destroy: %s is not unique.\n", s);
	return(-1);
      }
  }


/*
 * MatchesSuffix:
 * Returns TRUE if s1 is a suffix of s; else returns FALSE.
 */

int MatchesSuffix(s, s1)
    char *s, *s1;
  {
    char *p;
    char *p1;

    for (p = s + strlen(s) - 1, p1 = s1 + strlen(s1) -1;
    	 (p >= s) && (p1 >= s1);
	 p--, p1--)
      {
	if (*p != *p1)
	  {
	    break;
	  }
      }
    if (p1 < s1)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }
