/*
 * vectime.c - time some vectors on the VGTS
 *
 * Bill Nowicki April 1983
 * Based on some undocumented hacks by Vaughan Pratt
 */

# include <Vgts.h>
# ifdef Vsystem
# include <Venviron.h>
# include <Vio.h>
# include <Vtermagent.h>
# else Vsystem
# include <stdio.h>
# endif Vsystem

short sdf, vgt;

# define NumberLines 48		/* number of lines in test pad */
# define NumberColumns 80	/* columns in test pad */
# define NumberTrials 50	/* maximum number of trials */

int CreateTime[NumberTrials], DrawTime[NumberTrials];

int Trials = 10;

# define RADIUS 350
# define AGON 36	/* Number of sides in the plygon we are drawing */
# define NumberVectors (AGON*(AGON-1)/2)
# define TIMES 10	/* number of times to draw pattern */
# define XCENT 360	/* Center of pattern */
# define YCENT 360


Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }


Calculate()
  {
    int cos, sin, cx[AGON], cy[AGON], x, y, i, j, vecs, pixels;

    pixels = 0;
    vecs = 0;
    printf("c\r\nVector calculations\r\n"); fflush(stdout);
    cx[0] = RADIUS;
    cy[0] = 0;
    cos = 32270;	/* cos 10 degrees * 32768 */
    sin = 5690;	/* sin 10 degrees * 32768 */
    for (i = 1; i < AGON; i++) 
      {
	x = cx[i-1]*cos - cy[i-1]*sin + 16384;
	y = cx[i-1]*sin + cy[i-1]*cos + 16384;
	cx[i] = x>>15;
		cy[i] = y>>15;
	}
	for (i = 0; i < AGON; i++) 
	  {
		cx[i] = cx[i] + XCENT;
		cy[i] = cy[i] + YCENT;
	  }

    for (i = 0; i < AGON; i++)
	for (j = i+1; j < AGON; j++) 
	   {
	     double temp, sqrt();

	     vecs++;
	     temp = (cx[i]-cx[j])*(cx[i]-cx[j]) +
	     			 (cy[i]-cy[j])*(cy[i]-cy[j]) ;
	     pixels += (int) sqrt( temp );
	   }

  printf( "There were %d vectors and %d pixels\r\n", 
  		vecs, pixels );
  fflush(stdout);
}

DoAGon(slow)
  {
    int cos, sin, cx[AGON], cy[AGON], x, y, i, j, start = GetMilliseconds();
    int this = 0, createAvg, drawAvg;
    double createDev, drawDev;

    printf("%s\r\nVector drawing test\r\n", slow ? "a" : "b"); 
    fflush(stdout);
    cx[0] = RADIUS;
    cy[0] = 0;
    cos = 32270;	/* cos 10 degrees * 32768 */
    sin = 5690;	/* sin 10 degrees * 32768 */
    for (i = 1; i < AGON; i++) 
      {
	x = cx[i-1]*cos - cy[i-1]*sin + 16384;
	y = cx[i-1]*sin + cy[i-1]*cos + 16384;
	cx[i] = x>>15;
	cy[i] = y>>15;
       }
    for (i = 0; i < AGON; i++) 
      {
	cx[i] = cx[i] + XCENT;
	cy[i] = cy[i] + YCENT;
      }

   for (this=0; this<Trials; this++)
    {
      DeleteSymbol( sdf, 1);
      DefineSymbol( sdf, 1, "bench" );
      DisplayItem( sdf, 1, vgt);
      start = GetMilliseconds();
      for (i = 0; i < AGON; i++)
	for (j = i+1; j < AGON; j++)
	  {
  	    AddItem(sdf,0,cx[i],cx[j],cy[i],cy[j],0,SDF_GENERAL_LINE,0);
	    if (slow)
	      {
                EndSymbol(sdf,1,vgt);
                EditSymbol(sdf,1);
	      }
	  }

    CreateTime[this] = GetMilliseconds() - start;
    printf( "Creating: %d ms. %d vps ", CreateTime[this],
    		(NumberVectors*1000+500)/CreateTime[this] );
    start = GetMilliseconds();
    EndSymbol(sdf,1,vgt);
    DrawTime[this] = GetMilliseconds() - start;
    printf( "Drawing: %d ms. %d vps\r\n", DrawTime[this],
    		DrawTime[this] ? (NumberVectors*1000+500)/DrawTime[this] : 999);
   }
 createAvg = 0;
 drawAvg = 0;
 for (this=0;this<Trials;this++)
   {
     createAvg += CreateTime[this];
     drawAvg   += DrawTime[this];
   }
 createAvg /= Trials;
 drawAvg /= Trials;
   
 createDev = 0.0;
 drawDev = 0.0;
 for (this=0;this<Trials;this++)
   {
     register temp;

     temp = (CreateTime[this] - createAvg);
     createDev += temp*temp;
     temp = (DrawTime[this] - drawAvg);
     drawDev += temp*temp;
   }
 createDev = sqrt(createDev)/Trials;
 drawDev = sqrt(drawDev)/Trials;

 if (createAvg==0) createAvg = 1;
 if (drawAvg==0) drawAvg = 1;

 printf("Average create: %d ms. %3.1f vps, deviation %3.2f\r\n", 
 	createAvg, NumberVectors*1000.0/createAvg, createDev);
 printf("Average draw time: %d ms. %3.1f vps, deviation %3.2f\r\n", 
 	drawAvg, NumberVectors*1000.0/drawAvg, drawDev);
 printf("Total time: %d ms. %3.1f vps, deviation %3.2f\r\n", 
 	drawAvg+createAvg, NumberVectors*1000.0/(drawAvg+createAvg),
	drawDev+createDev);
}


TextTest(scrollFlag)
  {
# ifndef VAX
     File *test, *in, *MyOpenPad();
     SystemCode err;
     char c;
     int i, j, start, numberChars;
     int redrawStart, redrawTime, endTime;

     printf("Text time test (%s)\r\n", scrollFlag ? "scrolling" :"no scrolling");
     Flush(stdout);
     test = MyOpenPad( "Test", NumberLines, NumberColumns, &err );
     if (test==NULL)
       {
         printf("Error %s opening the pad\r\n", ErrorString(err) );
         return;
       }
     ModifyPad(test,LF_Output+PageOutputEnable);
     in = OpenFile( test->fileserver, test->fileid, FREAD, &err );
     if (in==NULL)
       {
         printf("Error %s opening the input\r\n", ErrorString(err) );
	 Close(test);
       }
      start = GetMilliseconds();
      redrawTime = 0;
      for ( c = 'A'; c < 'A'+10; c++)
        {
         for (i=0; i<NumberLines; i++)
	   {
	     for (j=0; j<NumberColumns; j++) 
	        {
	     	    putc(c,test);
		}
	     putc('\n',test);
	     if (scrollFlag)
	       {
                 Flush(test);
		 redrawStart = GetMilliseconds();
  	         RedrawPad(test);
		 redrawTime += (GetMilliseconds() - redrawStart );
	       }
	   }	
          Flush(test);
	  redrawStart = GetMilliseconds();
          RedrawPad(test);
	  redrawTime += (GetMilliseconds() - redrawStart );
	}
      endTime = GetMilliseconds();
      numberChars = NumberLines*NumberColumns*10;
      printf( "10 pages took %d milliseconds\r\n", endTime - start );
      printf( "of which %d milliseconds was drawing time\r\n", redrawTime);
      if (scrollFlag) numberChars *= NumberLines;
      printf( "Drawing rate of %d characters/second.\r\n", 
      	numberChars*1000/(redrawTime) );
      if (scrollFlag) numberChars /= NumberLines;
      printf( "Construction rate of %d characters/second.\r\n", 
      	numberChars*1000/(endTime-start-redrawTime) );
      printf( "Net rate of %d characters/second.\r\n", 
      	numberChars*1000/(endTime-start) );
      Close(test);
# endif VAX
  }

SetTrials()
  {
    while (1)
      {
        printf("n\r\nEnter number of trials: ");
	ResetTTY();
        fflush(stdout);
        scanf("%d",&Trials);
	getchar();		/* throw away extra \n */
	if (Trials>0) 
	  {
	    printf("Will perform %d trials\r\n", Trials);
            GetTTY();
	    return;
	  }
      }
  }

main()
  {
# ifdef VAX  
     printf("Remote VGTS vector benchmark\n");
# else VAX
     printf("VGTS vector benchmark\n");
# endif VAX
     fflush(stdout);
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, "bench" );
     EndSymbol( sdf, 1, 0 );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "random objects" );
     CreateView(vgt, 4, 4, 720, 740, 0, 0, 0, 0);
     printf("sdf=%d, vgt=%d\r\r\n", sdf, vgt);
     while (1)
      {
        register char c;
	    
	fflush(stdin);
        printf("a - adding test\r\n");
        printf("b - batch test\r\n");
	printf("n - number of trials\r\n");
        printf("c - caculate statistics\r\n");
        printf("t - Text redraw test\r\n");
        printf("s - Scrolling Test\r\n");
	printf( "Enter command:");
	fflush(stdout);
	switch (c = getchar())
	   {
	    case 'a': DoAGon(1); 	break;
	    case 'b': DoAGon(0); 	break;
	    case 'c': Calculate(); 	break;
	    case 't': TextTest(0); 	break;
	    case 's': TextTest(1); 	break;
	    case 'n': SetTrials();	break;
	    case 'q': printf("\r\n"); Quit();
	   }
       }
  }

# ifndef Vsystem

# include <sys/types.h>
# include <sys/timeb.h>

  GetMilliseconds()
    {
      struct timeb tp;

      ftime(&tp);
      return( tp.time*1000 + tp.millitm);
    }
# else Vsystem

# include <Vioprotocol.h>
# include <Vtermagent.h>

extern File *_Open();

File *MyOpenPad(name, lines, columns, error)
  char *name;
  short lines, columns, *error;
  {
    CreateInstanceRequest req;
    
    if (name==NULL) name = "Unknown";
    req.requestcode = CREATE_INSTANCE;
    req.filenamelen = strlen(name);
    req.filenameindex = 0;
    req.filename = name;
    req.type = 0;
    req.unspecified[0] = lines;
    req.unspecified[1] = columns;
    return( _Open(&req, FCREATE|FRELEASE_ON_CLOSE, 
    	stdin->fileserver, error) );

  }

 
GetMilliseconds()
    {
	/*
	 * Return the time in milliseconds on V-System
	 */
      long ticks, seconds;

      seconds = GetTime(&ticks);
      return( seconds*1000 + ticks*10);
    }

# endif Vsystem
