
/*
 * Structure test for VGTS
 * Bill Nowicki May 1984
 */

# include <Vgts.h>
# include <stdio.h>

short 	InvSymbol,	/* Symbol names to call */
	CuttSymbol,
	ButtSymbol,
	Butt3Symbol,
	Butt9Symbol,
	BigSymbol,
	Unique = 1;

int  Level;		/* Level of structure used 
			(+ = none, 0 = one level, - = calls) */
int  Incremental;	/* display after every item */
int  Trials = 10;	/* number of trials to average */
int  Boxes;		/* counts the number of boxes */
# define NumberTrials 50	/* maximum number of trials */
# define AllLevels 9999

int CreateTime[NumberTrials], DrawTime[NumberTrials];


short sdf, vgt;


Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

box(x,y,layer,xmax,ymax)
  {
    AddItem(sdf,0,x,xmax,y,ymax,layer,SDF_FILLED_RECTANGLE,NULL);
    Boxes++;
    if (Incremental)
      {
        EndSymbol(sdf,BigSymbol,vgt);
	EditSymbol(sdf,BigSymbol);
      }
  }

cutt(x,y)
  {

    if (Level-- < 0)
      {
    	  AddCall( sdf, 0, x, y, CuttSymbol);
	  return;
      }
    box (x + 0,y + 0,NM, x + 4,y + 4);
    box (x + 1,y + 1,NC, x + 3,y + 3);
    box (x + 0,y + 0,ND, x + 4,y + 4);
  }

buttt(x,y)
  {

    if (Level-- < 0)
      {
    	  AddCall( sdf, 0, x, y, ButtSymbol);
	  return;
      }
    box (x + 0,y + 0,NM, x + 6,y + 4);
    box (x + 1,y + 1,NC, x + 5,y + 3);
    box (x + 3,y + 0,NP, x + 6,y + 4);
    box (x + 0,y + 0,ND, x + 4,y + 4);
  }


buttt3(x,y)
  {
	/*
	 * This was a yale symbol, but it only occurs once.
	 *
    if (Level-- < 0)
      {
    	  AddCall( sdf, 0, x, y, Butt3Symbol);
	  return;
      }	**************/
    box (x + 0,y - 6,NM, x + 4,y - 0);
    box (x + 1,y - 5,NC, x + 3,y - 1);
    box (x + 0,y - 6,NP, x + 4,y - 3);
    box (x + 0,y - 4,ND, x + 4,y - 0);
  }


buttt9(x,y)
  {

	/*
	 * This was a yale symbol, but it only occurs once.
	 *
    if (Level-- < 0)
      {
    	  AddCall( sdf, 0, x, y, Butt9Symbol);
	  return;
      } **************/
    box (x - 4,y + 0,NM, x - 0,y + 6);
    box (x - 3,y + 1,NC, x - 1,y + 5);
    box (x - 4,y + 3,NP, x - 0,y + 6);
    box (x - 4,y + 0,ND, x - 0,y + 4);
  }


inv(x,y)
  {
# define p_width 6
# define y1 5
# define x1 12
# define y2 19

    if (Level-- < 0)
      {
    	  AddCall( sdf, 0, x, y, InvSymbol);
	  return;
      }
    buttt9(x + p_width/2+4,y + y1+3);
    buttt3(x + x1+4,y + y1+8);

    cutt(x + p_width/2,y);
    cutt(x + p_width/2,y + y2);

    box (x + 2, y + 3,ND, x + 2+p_width,y + y1+7);
    box (x + 2+p_width, y + y1+3,ND, x + p_width+3,y + y1+5);
    box (x + p_width+3, y + y1+3,ND, x + p_width+5,y + y1+8);
    box (x + p_width+5, y + y1+6,ND, x + x1+4,y + y1+8);
    box (x + 1+p_width/2, y + y1+7,ND, x + 3+p_width/2,y + y2);
    box (x + 2, y + y1+6,NP, x + 2+p_width,y + y1+13);
    box (x + 0, y + y1,NP, x + 4+p_width,y + y1+2);
    box (x + x1+4, y + y1,NP, x + x1+9,y + y1+2);
    box (x + 0, y + 0,NM, x + x1+9,y + 4);
    box (x + 0, y + y2,NM, x + x1+9,y + y2+4);
    box (x + p_width/2-1, y + y1+5,NI, x + p_width/2+5,y + y1+15);
    box (x + x1+0, y,NP, x + x1+2,y + y2+7);
  }

big()
  {
    inv(0,0);    inv(0,20);    inv(0,40);   inv(0,60);   inv(0,80);
    inv(20,0);   inv(20,20);   inv(20,40);  inv(20,60);  inv(20,80);
    inv(40,0);   inv(40,20);   inv(40,40);  inv(40,60);  inv(40,80);
    inv(60,0);   inv(60,20);   inv(60,40);  inv(60,60);  inv(60,80);
    inv(80,0);   inv(80,20);   inv(80,40);  inv(80,60);  inv(80,80);
    inv(100,0);  inv(100,20);  inv(100,40); inv(100,60); inv(100,80);
  }
# define RealItems 780  /* true number of items */


main()
  {
# ifndef Vsystem
     printf("Remote VGTS structure benchmark\n");
# else Vsystem
     printf("Local VGTS structure benchmark\n");
# endif Vsystem
     fflush(stdout);
     GetTTY();
     sdf = CreateSDF();
     BigSymbol = Unique++;
     CuttSymbol = Unique++;
     InvSymbol = Unique++;
     ButtSymbol = Unique++;
     Butt3Symbol = Unique++;
     Butt9Symbol = Unique++;
     DefineSymbol( sdf, BigSymbol, "bench" );
     EndSymbol( sdf, BigSymbol, 0 );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "structure test" );
     CreateView(vgt, 16, 16, 600, 480, -4, -2, 2, 0);
     printf("sdf=%d, vgt=%d\r\r\n", sdf, vgt);
     while (1)
      {
        register char c;
	    
	fflush(stdin);
	if ( feof(stdin) || ferror(stdin))
	  {
	   printf("Error on standard input\r\n");
	   exit();
	  }
        printf("i - incremental test\r\n");
        printf("b - batch test\r\n");
        printf("s - structure test\r\n");
	printf("n - number of trials\r\n");
	printf("q - quit\r\n");
	printf( "Enter command:");
	fflush(stdout);
	switch (c = getchar())
	   {
	    case 'i': DoInc();	 	break;
	    case 'b': DoBatch(); 	break;
	    case 's': DoStruct(); 	break;
	    case 'n': SetTrials();	break;
	    case 'q': printf("\r\n"); 	Quit();
	    default:
	       printf("%c ?? Unknown command\r\n", c);
	   }
       }
  }


SetTrials()
  {
    while (1)
      {
        printf("n\r\nEnter number of trials: ");
	ResetTTY();
        fflush(stdout);
        scanf("%d",&Trials);
	getchar();		/* throw away extra \n */
	if (Trials>0) 
	  {
	    printf("Will perform %d trials\r\n", Trials);
            GetTTY();
	    return;
	  }
      }
  }

DoInc()
  {
  	/*
	 * Incremental test - no structure, display after every operation
	 */
    int start, stop, this;

    printf("i\r\nIncremental test\r\n");
    fflush(stdout);
    for (this=0; this<Trials; this++)
      {
        Level = AllLevels; 
        Boxes = 0;
        Incremental = 1;
        start = GetMilliseconds();
        DeleteSymbol(sdf,BigSymbol);
        DefineSymbol(sdf,BigSymbol, "bench" );
        DisplayItem( sdf, BigSymbol, vgt);
        big(0, 0);
        EndSymbol( sdf, BigSymbol, vgt );
        CreateTime[this] = stop = GetMilliseconds() - start;
	DrawTime[this] = 0;
        printf("%d Items in %d ms, or %d items/second\r\n", Boxes, stop,
    	 (Boxes*1000 + 500)/stop );
      }
    DoAverage(Boxes,Boxes);
 }


DoBatch()
  {
  	/*
	 * Batch test - no structure, but defer display
	 */
    int start, define, stop, this;

    printf("b\r\nBatch test\r\n");
    fflush(stdout);
    
    for (this=0; this<Trials; this++)
      {
        Level = AllLevels; 
    	Boxes = 0;
    	Incremental = 0;
    	start = GetMilliseconds();
    	DeleteSymbol(sdf,BigSymbol);
    	DefineSymbol(sdf,BigSymbol, "bench" );
    	DisplayItem( sdf, BigSymbol, vgt);
    	big(0, 0);
    	define = GetMilliseconds();
    	EndSymbol( sdf, BigSymbol, vgt );
    	stop = GetMilliseconds();
	CreateTime[this] = define-start;
	DrawTime[this] = stop-define;
    	printf("Total %d items/second\r\n", (Boxes*1000 + 500)/(stop-start) );
      }
    DoAverage(Boxes,Boxes);
  }


DoAverage(defined,drawn)
  {
	/*
	 * calculate the average define, draw, and total times.
	 */
    int this, createAvg, drawAvg;
    double createDev, drawDev, sqrt();

 createAvg = 0;
 drawAvg = 0;
 for (this=0;this<Trials;this++)
   {
     createAvg += CreateTime[this];
     drawAvg   += DrawTime[this];
   }
 createAvg /= Trials;
 drawAvg /= Trials;
   
 createDev = 0.0;
 drawDev = 0.0;
 for (this=0;this<Trials;this++)
   {
     register temp;

     temp = (CreateTime[this] - createAvg);
     createDev += temp*temp;
     temp = (DrawTime[this] - drawAvg);
     drawDev += temp*temp;
   }
 createDev = sqrt(createDev)/Trials;
 drawDev = sqrt(drawDev)/Trials;

 if (createAvg==0) createAvg = 1;
 if (drawAvg==0) drawAvg = 1;

 printf("Average create: %d items in %d ms. %3.1f ips, deviation %3.2f\r\n", 
 	defined, createAvg, defined*1000.0/createAvg, createDev);
 printf("Average draw: %d items in %d ms. %3.1f ips, deviation %3.2f\r\n", 
 	drawn, drawAvg, drawn*1000.0/drawAvg, drawDev);
 printf("Total time: %d ms. %3.1f ips, deviation %3.2f\r\n", 
 	drawAvg+createAvg, drawn*1000.0/(drawAvg+createAvg),
	drawDev+createDev);
 }


DoStruct()
  {
  	/*
	 * Structure test - structure, and defer display
	 */
    int start, define, stop, this;
    printf("s\r\nStruct test\r\n");
    fflush(stdout);

    for (this=0;this<Trials;this++)
      {
    	Boxes = 0;
    	Incremental = 0;
    	start = GetMilliseconds();

    	DeleteSymbol(sdf,CuttSymbol);
    	DefineSymbol(sdf,CuttSymbol,"cutt");
    	Level = 0;
    	cutt(0,0);
    	EndSymbol(sdf,CuttSymbol,0);

/****** Don't bother defining symbols that occur once only
    	DeleteSymbol(sdf,Butt3Symbol);
    	DefineSymbol(sdf,Butt3Symbol,"butt3");
    	Level = 0;
    	buttt3(0,0);
    	EndSymbol(sdf,Butt3Symbol,0);

    	DeleteSymbol(sdf,Butt9Symbol);
    	DefineSymbol(sdf,Butt9Symbol,"butt9");
    	Level = 0;
    	buttt9(0,0);
    	EndSymbol(sdf,Butt9Symbol,0);
*********/

    	DeleteSymbol(sdf,InvSymbol);
    	DefineSymbol(sdf,InvSymbol,"inv");
    	Level = 0;
    	inv(0,0);
    	EndSymbol(sdf,InvSymbol,0);

    	DeleteSymbol(sdf,BigSymbol);
    	DefineSymbol(sdf,BigSymbol, "bench" );
    	DisplayItem( sdf, BigSymbol, vgt);
    	Level = -1; 
    	big(0, 0);
    	define = GetMilliseconds();
    	EndSymbol( sdf, BigSymbol, vgt );
    	stop = GetMilliseconds();
	CreateTime[this] = define - start;
	DrawTime[this] = stop - define;
    	printf("Total %d items/second\r\n", 
		(RealItems*1000 + 500)/(stop-start) );
      }
    DoAverage(Boxes,RealItems);
 }

# ifndef Vsystem

# include <sys/types.h>
# include <sys/timeb.h>

  GetMilliseconds()
    {
    	/* Unix Version */
      struct timeb tp;

      ftime(&tp);
      return( tp.time*1000 + tp.millitm);
    }
# else Vsystem

  GetMilliseconds()
    {
	/*
	 * Return the time in milliseconds (V version)
	 */
      long ticks, seconds;

      seconds = GetTime(&ticks);
      return( seconds*1000 + ticks*10);
    }

# endif Vsystem
