/*
 * binsun.c - display a binary file on the VGTS
 */

# include <Vgts.h>

# ifndef VAX
# include <Vio.h>
# else VAX
# include <stdio.h>
# define File FILE
# endif VAX

# define SCALE 2763

short sdf, vgt;

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

main(argc, argv)
 char **argv;
 {
    int	screenx, screeny, lastx, lasty, ipen;
    int i,vecs,start,end;
    short item;
    File *f;

     if ( argc > 1 ) f=fopen( argv[1], "r" );
     else 
      {
        printf("usage: %s file.bin\n", argv[0]);
	exit();
      }

     if (f==NULL)
         {
	 	/*
		 * Very primitive search path mechanism
		 */
	   char name[128];
	   sprintf(name, "%s.bin", argv[1]);
	   printf("Unable to open %s, trying %s ", argv[1], name );
	   f = fopen( name, "r");
	 }
     if (f==NULL)
         {
	   char name[128];
	   sprintf(name, "/ng/ng/V/cmds/demo/%s.bin", argv[1]);
	   printf("trying %s ", name );
	   f = fopen( name, "r");
	 }
     if (f==NULL)
         {
	   char name[128];
	   sprintf(name, "/ng/ng/V/cmds/demo/%s", argv[1]);
	   printf("trying %s ", name );
	   f = fopen( name, "r");
	 }

     if (f==NULL)
         {
           printf( "Cannot open %s\n", argv[1] );
	   exit(1);
         }

     printf("\nBinary to VGTS program\n");
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, argv[1] );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, argv[0] );
     DefaultView(vgt, 0, 0, -1000, 50, -2, 0, 0, 0);
     if (sdf<0 || vgt<0) printf("sdf=%d, vgt=%d\r\n", sdf,vgt);
     fflush(stdout);

     lastx = lasty = 0;
     i = 0;
     vecs = 0;
     time(&start);

     while (feof(f)==0 ) 
      {
	screenx = (getc(f) & 0377) << 8;
	screenx += getc(f) & 0377;

	screeny = (getc(f) & 0377) << 8;
	screeny += getc(f) & 0377;

	ipen = getc(f);

	if (ipen==1)
	 {
	    AddItem( sdf, 0, lastx, screenx, lasty, screeny, 0, 
	    	SDF_GENERAL_LINE, 0);
	    if (!(vecs++ % 1000))
	      {
	        printf("."); Flush(stdout);
		EndSymbol( sdf, 1, vgt );
		EditSymbol( sdf, 1 );
	      }
	 }
	lastx = screenx;
	lasty = screeny;
       }
     EndSymbol( sdf, 1, vgt );
     time(&end);
     printf("\r\n%d vectors in %d seconds, or %d vectors/second\r\n",
     	vecs, end-start, vecs/(end-start));
     printf("hit return to erase:\r\n"); fflush(stdout); getchar();
     Quit();
  }
