/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer, Eric Berglund,  5/83
 */


/*
 * Primary include file for Vdb.
 */

#define FALSE 0
#define TRUE 1

/* Put these here since lots of routines call them */
extern char GetMemByte();
extern short GetMemWord();
extern int GetInstrWord();
extern long GetMemLong();

typedef unsigned long memaddr;

#define TEAM_ORIGIN ((memaddr) 0)

#define STOP_TEAM_PRIORITY 0xff00 /* NULL_PROCESS_PRIORITY + 1 */

#define LineLength 256		/* Max size of input line. */
#define MaxArgs 32		/* Max number of arguments. */
#define ARGDELIM ','		/* Delimiter character for input args. */

#define PAGE_LENGTH 24		/* Number of lines to use for display-page
				   commands. */
#define MAX_CODE_LINE_LENGTH 80	/* Disassembler line limit. */
#define DEFRADIX  16		/* Default radix for input and output. */
#define DEFOFFSET 0xfff		/* Offset from a symbol allowed by dasm. */

#define INSTRBLK  512		/* Size of program memory cached in debugger's
				   team space. */

#define CacheSize 100		/* For saving symbol table entries. This
				   is enough even for very large programs. */
#define MAXNUMPARAMSTOPRINT 10  /* No. of parameters to print in stackdump. */

#define BPMAX		16	/* Number of breakpoints allowed */

#define SSBP		0	/* Index of breakpoint used for subroutine
				   single-stepping. */
#define TRBP		1	/* Index of breakpoint used for trap
				   single-stepping. */
#define ANY		BPMAX	/* Indicates any breakpoint. */

#define ATBREAKPOINT		TRUE
#define NOT_ATBREAKPOINT	FALSE
#define EXCEPTION		TRUE
#define NOT_EXCEPTION		FALSE
#define NOARGS  6		/* Maximum number of opcode args for dasm. */
#define NEARGS  3		/* Maximum number of eff.addr. args for dasm. */

#define MAXSYMLEN  128          /* Maximum symbol length that dasm will print--
				   must agree with dl68? */
#define DEF_MAXSYMLEN	16


/* Type definitions */
enum stype {
    NULLTYPE,       /* Default */
    CHARTYPE,       /* character type */
    BYTETYPE,       /* byte */
    WORDTYPE,       /* word */
    LONGTYPE,       /* long */
    INSTTYPE,       /* instruction */
    STRTYPE,        /* string */
    QUADTYPE,       /* Quadword (8 bytes) */
    OCTATYPE,       /* Octa-word (16 bytes) */
    FFLTTYPE,       /* F-floating (4 bytes) */
    DFLTTYPE,       /* D-floating (8 bytes) */
    GFLTTYPE,       /* G-floating (8 bytes) */
    HFLTTYPE,       /* H-floating (16 bytes) */
};

enum stype GiveTypeOutMode();

typedef long memaddr;           /* Memory address in debuggee */

/* VAX specific */

#define TRACEBIT        0x00000010  /* Trace bit in VAX PSL */

long SavedRegisters[16];	/* Current register values */
#define ProgramCounter SavedRegisters[PC]

long SavedPSL;                  /* Processor status longword */

/* Vax register numbers */
#define AP              12      /* argument pointer index in SavedRegisters */
#define FP              13      /* frame pointer index in SavedRegisters */
#define SP              14      /* stack pointer index in SavedRegisters */
#define PC              15      /* program counter */

#define BPINST          0x03    /* VAX BPT instruction */



#define PutMemByte( address, data )    PutMemData( address, data, 1 )
#define PutMemWord( address, data )    PutMemData( address, data, 2 )
#define PutMemLong( address, data )    PutMemData( address, data, 4 )
#define PutMemString( address, data, nbytes )  PutMemData( address, data, nbytes )

enum DbCmds			/* Vdb commands */
  {
    DisplayNextCmd,
    DisplayPrevCmd,
    DisplayPtrCmd,
    DisplayNextPageCmd,
    DisplayPrevPageCmd,
    DisplayEqCmd,
    DisplayRegCmd,
    ReplaceCmd,
    ReplaceRegCmd,
    GoCmd,
    GoBrkptCmd,
    SingleStepCmd,
    SingleStepSbrCmd,
    BpCmd,
    SearchCmd,
    MaskCmd,
    IRadixCmd,
    ORadixCmd,
    TmpTypeCmd,
    TypeCmd,
    StackTraceCmd,
    StopProcessCmd,
    OffsetCmd,
    SymLengthCmd,
    WatchCmd,
    WatchBrkptCmd,
    HelpCmd,
    QuitCmd,
    StatsCmd,
    BadCmd,
    NoCmd
  };



/* structure of a symbol table definition */
typedef struct Symtabdef
  {
    struct nlist *start;
    struct nlist *limit;
  } symtabdef;


/* breakpoint mechanism */
struct bpstr {
	memaddr pc;             /* pc at breakpoint */
	short count;		/* proceed counter */
	char  oldinst;          /* old instruction */
	unsigned inuse : 1;     /* this breakpoint is being used */
	};

struct bpstr bp[BPMAX];		/* breakpoint structures */
struct bpstr *cbptr;		/* current breakpoint or NULL */

/* Symbol table entry record */
typedef struct SymRecord
  {
    struct nlist symbol;        /* type, length, value, and */
    int slength;                /* Length of name */
    enum stype stype;           /* Type (not the same as n_type in nlist) */
    char symName[MAXSYMLEN];    /* name. */
  } SymRec;

/* type-out structure for dasm */
struct cbuffr
  {
    char buf[MAX_CODE_LINE_LENGTH];	/* output buffer */
    int pnt;			/* pointer into output buffer */
    int col;			/* output column number */
  };

struct cbuffr OutputBuffer, HexBuffer;
struct cbuffr *cbfp;		/* pointer to OutputBuffer or HexBuffer */


File *Symfile;			/* User program's symbol table file.
				   Normally the program's .r file. */
struct bhdr filhdr;             /* fileheader of the .o file */


ProcessId CurExceptionPid;	/* Pid of process which incurred
					   the current exception. */



memaddr LoadOrigin;             /* Start of non-kernel part of team space. */
memaddr LinkOrigin;             /* Address team was linked to run at,
				 *  normally equal to LoadOrigin */
memaddr DebugeeTeamSize;        /* Team size of program being debugged. */
memaddr Dot;                    /* last location examined */

char SsFlag;			/* flag set non-zero if single stepping */
char SsSbrFlag;			/* flag set non-zero if single stepping over
				   subroutine calls */
long SsCount;			/* how many single steps */


int LargestOffset;		/* ...(from a defined symbol) that can be
				   printed by dasm. Defaults to DEFOFFSET.*/

int StringLength;		/* length to use for strings which aren't
				   delimited by \0.  Default is 80. */

int MaxSymLength;		/* settable maximum number of characters
				   of a symbol name which can be displayed. */

enum stype SymType;             /* type of last symbol found */
int offset;			/* Offset in symbol table file of a 
				   symbol */

short InputRadix;		/* Defaults to DEFRADIX */
short OutputRadix;		/* Defaults to DEFRADIX */

enum stype TypeOutMode, TempTypeOutMode, ActualTypeOutMode;
				/* type-out modes */

char StopProcessFlag;		/* 0 if team stops on exception, else only
				   the process with the exception stops. */

char WatchFlag;			/* Are we staring at some address? */
char WatchBrkptFlag;		/* Are we only looking during breakpoints? */
memaddr WatchAddr;              /* What address is it? */
enum stype WatchType;           /* What type is the data? */
long OldWatchValue;             /* What used to be there? */

#ifdef Addr24
#define FixAddress(x) ((memaddr)((long)(x) & 0xFFFFFF))
#define DoFixAddress(xPtr) (*(long*)(xPtr) &= 0xFFFFFF)
#else
#define FixAddress(x) ((memaddr)(x))
#define DoFixAddress(xPtr)
#endif Addr24
